/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl.AbstractFederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicyOneOfOperator
extends AbstractFederationMetadataPolicyOperator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicyOneOfOperator.class);

    @Override
    @Nullable
    public Object apply(@Nullable Object candidate, @Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        List oneOf = policy.getOneOfValues();
        if (candidate == null || oneOf == null) {
            this.log.debug("No candidate or one_of value present. nothing to do");
            return candidate;
        }
        if (!oneOf.contains(candidate)) {
            throw new ConstraintViolationException("The candidate " + String.valueOf(candidate) + " is not included in the values for one_of: " + String.valueOf(oneOf));
        }
        return candidate;
    }

    @Override
    public boolean validate(@Nonnull MetadataPolicy policy) {
        List oneOf = policy.getOneOfValues();
        if (oneOf == null) {
            return true;
        }
        Object value = policy.getValue();
        if (value != null && !oneOf.contains(value)) {
            this.log.debug("The value {} is not included in the values for one_of: {}", value, (Object)oneOf);
            return false;
        }
        return true;
    }
}

