/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.FederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicyMergingStrategy
extends AbstractIdentifiableInitializableComponent
implements BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicyMergingStrategy.class);
    @NonnullAfterInit
    List<FederationMetadataPolicyOperator> operators;

    public void setMetadataPolicyOperators(@Nonnull List<FederationMetadataPolicyOperator> policyOperators) {
        this.checkSetterPreconditions();
        this.operators = (List)Constraint.isNotNull(policyOperators, (String)"List of metadata policy operators cannot be null");
    }

    @Override
    @Nonnull
    public Pair<Map<String, MetadataPolicy>, Boolean> apply(@Nullable Map<String, MetadataPolicy> first, @Nullable Map<String, MetadataPolicy> second) {
        if (first == null || first.isEmpty()) {
            return new Pair(second == null ? (first == null ? null : Collections.emptyMap()) : second, (Object)Boolean.TRUE);
        }
        if (second == null || second.isEmpty()) {
            return new Pair(first, (Object)Boolean.TRUE);
        }
        Set combinedKeys = Stream.concat(first.keySet().stream(), second.keySet().stream()).collect(Collectors.toSet());
        HashMap<String, MetadataPolicy> result = new HashMap<String, MetadataPolicy>();
        boolean valid = true;
        for (String key : combinedKeys) {
            try {
                MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)first.get(key), (MetadataPolicy)second.get(key));
                this.log.debug("Merging result of {} with {}: {}", new Object[]{first.get(key), second.get(key), merged});
                if (merged != null && merged.getOneOfValues() != null && merged.getOneOfValues().isEmpty()) {
                    this.log.warn("Value of 'one_of' operator is empty after merging");
                    valid = false;
                }
                result.put(key, merged);
                for (FederationMetadataPolicyOperator operator : this.operators) {
                    if (merged == null || operator.validate(merged)) continue;
                    valid = false;
                }
            }
            catch (ConstraintViolationException e) {
                this.log.warn("Incompatible metadata policies for claim '{}' that cannot be merged.", (Object)key);
                valid = false;
            }
        }
        return new Pair(result, (Object)valid);
    }
}

