/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.FederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicyEnforcer
extends AbstractIdentifiableInitializableComponent
implements BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicyEnforcer.class);
    @NonnullAfterInit
    List<FederationMetadataPolicyOperator> operators;

    public void setMetadataPolicyOperators(@Nonnull List<FederationMetadataPolicyOperator> policyOperators) {
        this.checkSetterPreconditions();
        this.operators = (List)Constraint.isNotNull(policyOperators, (String)"List of metadata policy operators cannot be null");
    }

    @Override
    @Nullable
    public Pair<Object, Boolean> apply(@Nullable Object candidate, @Nullable MetadataPolicy policy) {
        if (policy == null) {
            return new Pair(candidate, (Object)Boolean.TRUE);
        }
        Object operatorResult = candidate;
        for (FederationMetadataPolicyOperator operator : this.operators) {
            try {
                operatorResult = operator.apply(operatorResult, policy);
            }
            catch (ConstraintViolationException e) {
                this.log.debug("Operator {} returned a non-success result", operator.getClass());
                return new Pair(operatorResult, (Object)Boolean.FALSE);
            }
        }
        return new Pair(operatorResult, (Object)Boolean.TRUE);
    }

    protected boolean isSuccessResult(@Nullable Pair<Object, Boolean> result) {
        return Optional.ofNullable(result).map(pair -> (Boolean)pair.getSecond()).map(second -> (boolean)second).orElse(false);
    }
}

