/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl.AbstractFederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicyAddOperator
extends AbstractFederationMetadataPolicyOperator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicyAddOperator.class);

    @Override
    @Nullable
    public Object apply(@Nullable Object candidate, @Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        List<Object> add = DefaultFederationMetadataPolicyAddOperator.parseList(policy.getAdd());
        if (add != null) {
            if (candidate instanceof List) {
                List list = (List)candidate;
                this.log.debug("Combining candidate {} and add {}", (Object)list, add);
                return this.buildResult(Stream.concat(list.stream(), add.stream()));
            }
            if (candidate == null) {
                this.log.debug("Returning the contents of the add operator: {}", add);
                return this.buildResult(add.stream());
            }
            this.log.debug("Candidate value {} is not a list/array", candidate);
            throw new ConstraintViolationException("Candidate " + String.valueOf(candidate) + " is not a list/array");
        }
        return candidate;
    }

    @Nonnull
    protected List<Object> buildResult(Stream<?> stream) {
        List<Object> result = stream.filter(Object.class::isInstance).map(Object.class::cast).distinct().toList();
        assert (result != null);
        return CollectionSupport.copyToList(result);
    }

    @Override
    public boolean validate(@Nonnull MetadataPolicy policy) {
        List subsetOf;
        List<Object> add;
        try {
            add = DefaultFederationMetadataPolicyAddOperator.parseList(policy.getAdd());
        }
        catch (ConstraintViolationException e) {
            this.log.warn("The value for add operator {} is not a list/array", policy.getAdd());
            return false;
        }
        if (add == null || add.isEmpty()) {
            return true;
        }
        boolean validation = true;
        Object value = policy.getValue();
        if (value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            if (!MetadataPolicyHelper.isSubsetOfValues(add, (Collection)valueCollection)) {
                this.log.debug("The value for add operator {} is not a subset of value {}", add, (Object)valueCollection);
                validation = false;
            }
        } else if (value != null) {
            this.log.warn("The value {} is not a list/array", value);
            validation = false;
        }
        if ((subsetOf = policy.getSubsetOfValues()) != null && !MetadataPolicyHelper.isSubsetOfValues(add, (Collection)subsetOf)) {
            this.log.debug("The value for add operator {} is not a subset of value for the subset_of operator {}", add, (Object)subsetOf);
            validation = false;
        }
        return validation;
    }
}

