/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraint;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public abstract class AbstractFederationPolicyConstraint<T>
extends AbstractIdentifiableInitializableComponent
implements FederationPolicyConstraint {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractFederationPolicyConstraint.class);

    @Override
    public boolean validate(@Nullable Object constraint, @Nonnull List<EntityStatement> trustChain) {
        this.checkComponentActive();
        try {
            this.log.trace("Attempting to parse raw constraint value: {}", constraint);
            T constraintData = this.parseConstraint(constraint);
            if (constraintData != null) {
                return this.doValidate(constraintData, trustChain);
            }
            return true;
        }
        catch (ConstraintViolationException e) {
            return false;
        }
    }

    @Nullable
    protected abstract T parseConstraint(@Nullable Object var1) throws ConstraintViolationException;

    protected abstract boolean doValidate(@Nonnull T var1, @Nonnull List<EntityStatement> var2);
}

