/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class JWKSetDeserializer
extends JsonDeserializer<LocalKeyContainer> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWKSetDeserializer.class);

    public LocalKeyContainer deserialize(@Nullable JsonParser jsonParser, @Nullable DeserializationContext deserializationContext) throws IOException, JacksonException {
        assert (jsonParser != null);
        String raw = jsonParser.readValueAsTree().toString();
        this.log.trace("Raw string to be parsed into JWTSet: {}", (Object)raw);
        try {
            LocalKeyContainer keyContainer = new LocalKeyContainer();
            keyContainer.setJWKSet(JWKSet.parse((String)raw));
            return keyContainer;
        }
        catch (ParseException e) {
            throw new IOException("Could not parse JWKSet", e);
        }
    }
}

