/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.slf4j.Logger;

public class EntityStatementHelper {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(EntityStatementHelper.class);

    @Nonnull
    public static Map<String, Object> parseClaimAsMap(@Nonnull ObjectMapper objectMapper, @Nonnull EntityStatement entityStatement, @Nonnull String claim) {
        Object rawClaim = entityStatement.getClaimsSet().getClaim(claim);
        log.trace("Raw {} claim value: {}", (Object)claim, rawClaim);
        if (rawClaim != null) {
            JavaType objectType = objectMapper.constructType(Object.class);
            JavaType stringType = objectMapper.constructType(String.class);
            MapType objectMapType = objectMapper.getTypeFactory().constructMapType(Map.class, stringType, objectType);
            try {
                Map result = (Map)objectMapper.readValue(rawClaim.toString(), (JavaType)objectMapType);
                if (result != null) {
                    log.trace("Parsed {} map: {}", (Object)claim, (Object)result);
                    return result;
                }
            }
            catch (JsonProcessingException e) {
                log.warn("Could not parse " + claim + " from entity statement", (Throwable)e);
            }
        }
        log.trace("Returning empty map");
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    public static Map<String, Map<String, Object>> parseClaimAsMapOfMaps(@Nonnull ObjectMapper objectMapper, @Nonnull EntityStatement entityStatement, @Nonnull String claim) {
        Object rawClaim = entityStatement.getClaimsSet().getClaim(claim);
        log.trace("Raw {} claim value: {}", (Object)claim, rawClaim);
        if (rawClaim != null) {
            JavaType objectType = objectMapper.constructType(Object.class);
            JavaType stringType = objectMapper.constructType(String.class);
            MapType objectMapType = objectMapper.getTypeFactory().constructMapType(Map.class, stringType, objectType);
            MapType mapOfObjectMapType = objectMapper.getTypeFactory().constructMapType(Map.class, stringType, (JavaType)objectMapType);
            try {
                Map result = (Map)objectMapper.readValue(rawClaim.toString(), (JavaType)mapOfObjectMapType);
                if (result != null) {
                    log.trace("Parsed {} map: {}", (Object)claim, (Object)result);
                    return result;
                }
            }
            catch (JsonProcessingException e) {
                log.warn("Could not parse " + claim + " from entity statement", (Throwable)e);
            }
        }
        log.trace("Returning empty map");
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    public static Map<String, Map<String, Object>> parseMetadata(@Nonnull ObjectMapper objectMapper, @Nonnull EntityStatement entityStatement) {
        return EntityStatementHelper.parseClaimAsMapOfMaps(objectMapper, entityStatement, "metadata");
    }

    @Nullable
    public static EntityStatement deserializeEntityStatement(@Nullable String serialized) {
        try {
            if (serialized != null) {
                return EntityStatement.parse((String)serialized);
            }
        }
        catch (ParseException e) {
            log.trace("Could not construct entity statement from {}", (Object)serialized, (Object)e);
        }
        log.warn("Could not deserialize entity statement {}", (Object)serialized);
        return null;
    }

    @Nullable
    public static String getSerializedTrustChain(@Nullable List<EntityStatement> trustChain) {
        return trustChain == null ? null : String.join((CharSequence)",", trustChain.stream().map(es -> es.getSignedStatement().serialize()).toList());
    }

    @Nullable
    public static String getSerializedEntityStatement(@Nullable EntityStatement entityStatement) {
        return entityStatement == null ? null : entityStatement.getSignedStatement().serialize();
    }

    @Nullable
    public static URI fetchEndpointUriFromFederationEntity(@Nonnull MetadataCache<EntityStatement> cache, @Nonnull String entityId, @Nonnull String endpointId, @Nonnull ObjectMapper objectMapper) {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(entityId)});
        try {
            List result = cache.get(criteria);
            if (!result.isEmpty()) {
                return Optional.ofNullable(EntityStatementHelper.parseMetadata(objectMapper, (EntityStatement)result.get(0)).get("federation_entity")).filter(Map.class::isInstance).map(map -> map).map(map -> map.get(endpointId)).filter(String.class::isInstance).map(String.class::cast).map(URI::create).orElse(null);
            }
        }
        catch (MetadataCacheException e) {
            log.debug("Error while fetching entity configuration for {}", (Object)entityId, (Object)e);
        }
        log.warn("Could not fetch entity configuration for {}", (Object)entityId);
        return null;
    }
}

