/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.TrustMarkStatusRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.TrustMarkStatusResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.AbstractFederationEndpointResponseFetchingStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkStatusRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkStatusResponseContainer;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultTrustMarkStatusFetchingStrategy
extends AbstractFederationEndpointResponseFetchingStrategy<TrustMarkStatusRequest, TrustMarkStatusResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustMarkStatusFetchingStrategy.class);

    public DefaultTrustMarkStatusFetchingStrategy() {
        this.setCriteriaToRequestStrategy(criteria -> {
            TrustMarkStatusRequestCriterion requestCriterion = (TrustMarkStatusRequestCriterion)criteria.get(TrustMarkStatusRequestCriterion.class);
            if (requestCriterion == null) {
                this.log.debug("No request criterion given, returning null");
                return null;
            }
            return requestCriterion.getRequest();
        });
    }

    @Override
    @Nullable
    protected ClassicHttpRequest initializeHttpRequest(@Nonnull CriteriaSet criteria, @Nonnull TrustMarkStatusRequest request) {
        HttpPost httpRequest = new HttpPost(request.getEndpointURI());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("trust_mark", request.getTrustMark().serialize()));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
        httpRequest.setEntity((HttpEntity)urlEncodedFormEntity);
        httpRequest.setHeader("Content-Type", (Object)ContentType.APPLICATION_FORM_URLENCODED);
        return httpRequest;
    }

    @Override
    @Nullable
    protected TrustMarkStatusResponseContainer parseHttpResponse(@Nonnull CriteriaSet criteria, @Nonnull TrustMarkStatusRequest request, @Nullable ClassicHttpResponse response) throws ProtocolException, IOException {
        ResponseContainerExpirationCriterion expirationCriterion = (ResponseContainerExpirationCriterion)criteria.get(ResponseContainerExpirationCriterion.class);
        if (expirationCriterion == null) {
            this.log.debug("No expiration criterion given, returning null");
            return null;
        }
        if (response != null) {
            HTTPResponse nimbusResponse = new HTTPResponse(response.getCode());
            nimbusResponse.setContent(EntityUtils.toString((HttpEntity)response.getEntity()));
            try {
                nimbusResponse.setContentType(response.getEntity().getContentType());
                TrustMarkStatusResponse statusResponse = TrustMarkStatusResponse.parse(nimbusResponse);
                Instant expirationTime = expirationCriterion.getExpirationInstant();
                return new TrustMarkStatusResponseContainer(statusResponse, request.getTrustMark(), expirationTime);
            }
            catch (ParseException e) {
                this.log.warn("Could not parse resolve entity response from URI: {}", (Object)request.getEndpointURI(), (Object)e);
            }
        } else {
            this.log.debug("Unable to fetch resolve entity response from URI: {} (null response)", (Object)request.getEndpointURI());
        }
        return null;
    }
}

