/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.TrustMarkRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.TrustMarkResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.AbstractFederationEndpointResponseFetchingStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkResponseContainer;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultTrustMarkFetchingStrategy
extends AbstractFederationEndpointResponseFetchingStrategy<TrustMarkRequest, TrustMarkResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustMarkFetchingStrategy.class);

    public DefaultTrustMarkFetchingStrategy() {
        this.setCriteriaToRequestStrategy(criteria -> {
            TrustMarkRequestCriterion requestCriterion = (TrustMarkRequestCriterion)criteria.get(TrustMarkRequestCriterion.class);
            if (requestCriterion == null) {
                this.log.debug("No request criterion given, returning null");
                return null;
            }
            return requestCriterion.getRequest();
        });
    }

    @Override
    @Nullable
    protected ClassicHttpRequest initializeHttpRequest(@Nonnull CriteriaSet criteria, @Nonnull TrustMarkRequest request) {
        HttpGet httpRequest = new HttpGet(request.getEndpointURI());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("trust_mark_type", request.getTrustMarkType()));
        nvps.add(new BasicNameValuePair("sub", request.getSubject()));
        try {
            URI uri = new URIBuilder(httpRequest.getUri()).addParameters(nvps).build();
            httpRequest.setUri(uri);
        }
        catch (URISyntaxException e) {
            this.log.error("Could not create URI with the given parameters {}", (Object)request, (Object)e);
        }
        return httpRequest;
    }

    @Override
    @Nullable
    protected TrustMarkResponseContainer parseHttpResponse(@Nonnull CriteriaSet criteria, @Nonnull TrustMarkRequest request, @Nullable ClassicHttpResponse response) throws ProtocolException, IOException {
        ResponseContainerExpirationCriterion expirationCriterion = (ResponseContainerExpirationCriterion)criteria.get(ResponseContainerExpirationCriterion.class);
        if (expirationCriterion == null) {
            this.log.debug("No expiration criterion given, returning null");
            return null;
        }
        if (response != null) {
            HTTPResponse nimbusResponse = new HTTPResponse(response.getCode());
            nimbusResponse.setContent(EntityUtils.toString((HttpEntity)response.getEntity()));
            try {
                nimbusResponse.setContentType(response.getEntity().getContentType());
                TrustMarkResponse parsedResponse = TrustMarkResponse.parse(nimbusResponse);
                Instant expirationTime = expirationCriterion.getExpirationInstant();
                return new TrustMarkResponseContainer(parsedResponse, request, parsedResponse.getJWT(), expirationTime);
            }
            catch (ParseException e) {
                this.log.warn("Could not parse resolve entity response from URI: {}", (Object)request.getEndpointURI(), (Object)e);
            }
        } else {
            this.log.debug("Unable to fetch resolve entity response from URI: {} (null response)", (Object)request.getEndpointURI());
        }
        return null;
    }
}

