/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultTrustChainTrustedTrustMarkOwnersLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<List<EntityStatement>, Map<String, Map<String, Object>>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultTrustChainTrustedTrustMarkOwnersLookupStrategy.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, Map<String, Object>> apply(@Nullable List<EntityStatement> trustChain) {
        this.checkComponentActive();
        if (trustChain == null || trustChain.size() < 3) {
            return null;
        }
        Object ownersClaim = trustChain.get(trustChain.size() - 1).getClaimsSet().getClaim("trust_mark_owners");
        this.log.debug("Raw trust_mark_owners claim {}", ownersClaim);
        if (ownersClaim != null) {
            JavaType objectType = this.objectMapper.constructType(Object.class);
            JavaType stringType = this.objectMapper.constructType(String.class);
            MapType objectMapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, stringType, objectType);
            MapType rootMapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, stringType, (JavaType)objectMapType);
            try {
                Map result = (Map)this.objectMapper.readValue(ownersClaim.toString(), (JavaType)rootMapType);
                if (result != null) {
                    this.log.debug("Parsed trust_mark_owners map {}", (Object)result);
                    return result;
                }
            }
            catch (JsonProcessingException e) {
                this.log.warn("Could not parse trust mark issuers from the trust chain", (Throwable)e);
            }
        }
        this.log.debug("Returning empty map");
        return CollectionSupport.emptyMap();
    }
}

