/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultTrustChainTrustedTrustMarkIssuersLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<List<EntityStatement>, Map<String, List<String>>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultTrustChainTrustedTrustMarkIssuersLookupStrategy.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, List<String>> apply(@Nullable List<EntityStatement> trustChain) {
        this.checkComponentActive();
        if (trustChain == null || trustChain.size() < 3) {
            return null;
        }
        return this.parseTrustedIssuers(trustChain).entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).map(entry -> Map.entry((String)entry.getKey(), Arrays.stream((String[])entry.getValue()).toList())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    protected Map<String, String[]> parseTrustedIssuers(@Nonnull List<EntityStatement> trustChain) {
        Object issuersClaim = trustChain.get(trustChain.size() - 1).getClaimsSet().getClaim("trust_mark_issuers");
        if (issuersClaim != null) {
            ArrayType arrayType = this.objectMapper.getTypeFactory().constructArrayType(String.class);
            JavaType stringType = this.objectMapper.constructType(String.class);
            MapType mapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, stringType, (JavaType)arrayType);
            try {
                Map result = (Map)this.objectMapper.readValue(issuersClaim.toString(), (JavaType)mapType);
                if (result != null) {
                    return result;
                }
            }
            catch (JsonProcessingException e) {
                this.log.warn("Could not parse trust mark issuers from the trust chain", (Throwable)e);
            }
        }
        return CollectionSupport.emptyMap();
    }
}

