/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.IssuerEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.PreSelectedTrustChainCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraint;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraintHelper;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultTrustChainFetchingStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, List<List<EntityStatement>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustChainFetchingStrategy.class);
    @NonnullAfterInit
    private Function<CriteriaSet, String> criteriaToSubjectEntityIdStrategy;
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;
    @NonnullAfterInit
    private MetadataCache<EntityStatement> subordinateStatementCache;
    @NonnullAfterInit
    private MetadataCache<Map<String, LocalKeyContainer>> localTrustAnchorsCache;
    @NonnullAfterInit
    private Map<String, FederationPolicyConstraint> federationPolicyConstraints;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setCriteriaToSubjectEntityIdStrategy(@Nonnull Function<CriteriaSet, String> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToSubjectEntityIdStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to subject entity ID strategy cannot be null");
    }

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity Configuration cache cannot be null");
    }

    public void setSubordinateStatementCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.subordinateStatementCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Subordinate statement cache cannot be null");
    }

    public void setLocalTrustAnchorsCache(@Nonnull MetadataCache<Map<String, LocalKeyContainer>> cache) {
        this.checkSetterPreconditions();
        this.localTrustAnchorsCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Local Trust Anchor cache cannot be null");
    }

    public void setfederationPolicyConstraints(@Nonnull Map<String, FederationPolicyConstraint> constraints) {
        this.checkSetterPreconditions();
        this.federationPolicyConstraints = (Map)Constraint.isNotNull(constraints, (String)"Map of policy constraints cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.criteriaToSubjectEntityIdStrategy == null) {
            throw new ComponentInitializationException("Criteria to subject entity ID strategy cannot be null");
        }
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity configuration cache cannot be null");
        }
        if (this.subordinateStatementCache == null) {
            throw new ComponentInitializationException("Subordinate statement cache cannot be null");
        }
        if (this.localTrustAnchorsCache == null) {
            throw new ComponentInitializationException("Local Trust Anchor cache cannot be null");
        }
        if (this.federationPolicyConstraints == null) {
            throw new ComponentInitializationException("Map of policy constraints cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public List<List<EntityStatement>> apply(@Nullable CriteriaSet criteria) {
        EntityStatement entityConfiguration;
        this.checkComponentActive();
        if (criteria == null) {
            return null;
        }
        PreSelectedTrustChainCriterion preSelectedCriterion = (PreSelectedTrustChainCriterion)criteria.get(PreSelectedTrustChainCriterion.class);
        List<String> preSelectedChain = preSelectedCriterion == null ? CollectionSupport.emptyList() : preSelectedCriterion.getValue();
        SubjectEntityStatementCriterion subjectStatementCriterion = (SubjectEntityStatementCriterion)criteria.get(SubjectEntityStatementCriterion.class);
        if (subjectStatementCriterion == null) {
            try {
                List entityConfigurations = this.entityConfigurationCache.get(criteria);
                if (entityConfigurations.isEmpty()) {
                    return null;
                }
                entityConfiguration = (EntityStatement)entityConfigurations.get(0);
            }
            catch (MetadataCacheException e) {
                this.log.error("Could not fetch entity configuration for the trust chain", (Throwable)e);
                return null;
            }
        } else {
            entityConfiguration = subjectStatementCriterion.getValue();
        }
        if (entityConfiguration == null) {
            return null;
        }
        List<List<EntityStatement>> rawChains = this.populateChain(CollectionSupport.listOf((Object)CollectionSupport.listOf((Object)entityConfiguration)), preSelectedChain);
        List<List<EntityStatement>> trustChains = this.stripIntermediateConfigurations(entityConfiguration, rawChains);
        return Stream.concat(trustChains.stream(), this.resolveLocallyTrustedTrustChains(trustChains).stream()).toList();
    }

    @Nonnull
    private List<List<EntityStatement>> stripIntermediateConfigurations(@Nonnull EntityStatement leaf, @Nonnull @NonnullElements List<List<EntityStatement>> chains) {
        ArrayList<List<EntityStatement>> result = new ArrayList<List<EntityStatement>>();
        for (List<EntityStatement> chain : chains) {
            result.add(chain.stream().filter(es -> es.equals(leaf) || es.getClaimsSet().getAuthorityHints() == null || es.getClaimsSet().getAuthorityHints().isEmpty() || !es.getEntityID().equals((Object)es.getClaimsSet().getIssuerEntityID())).toList());
        }
        return result;
    }

    @Nonnull
    private List<List<EntityStatement>> resolveLocallyTrustedTrustChains(@Nonnull @NonnullElements List<List<EntityStatement>> chains) {
        ArrayList<List<EntityStatement>> result = new ArrayList<List<EntityStatement>>();
        for (List<EntityStatement> chain : chains) {
            for (int i = 0; i < chain.size() - 1; ++i) {
                EntityStatement statement = chain.get(i);
                assert (statement != null);
                String entityId = chain.get(i).getEntityID().getValue();
                assert (entityId != null);
                if (!this.isLocallyTrusted(statement) || this.isTrustAnchor(entityId, result)) continue;
                try {
                    CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(entityId)});
                    EntityStatement localAnchorConfiguration = this.getFirstIfFound(this.entityConfigurationCache.get(criteria));
                    if (localAnchorConfiguration == null) continue;
                    ArrayList<EntityStatement> localTrustChain = new ArrayList<EntityStatement>(chain.subList(0, chain.indexOf(statement)));
                    localTrustChain.add(localAnchorConfiguration);
                    result.add(CollectionSupport.copyToList(localTrustChain));
                    this.log.debug("Included a trust chain based on a local trust anchor {}", (Object)entityId);
                    continue;
                }
                catch (MetadataCacheException e) {
                    this.log.error("Could not resolve entity configuration for {}", (Object)entityId);
                }
            }
        }
        return result;
    }

    private boolean isLocallyTrusted(@Nonnull EntityStatement statement) {
        List keyContainers;
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityStatementCriterion(statement)});
        String entityId = statement.getEntityID().getValue();
        assert (entityId != null);
        try {
            keyContainers = this.localTrustAnchorsCache.get(criteria);
        }
        catch (MetadataCacheException e) {
            this.log.debug("Could not resolve local trust anchor keys from the cache for {}", (Object)entityId, (Object)e);
            return false;
        }
        if (keyContainers.isEmpty() || !((Map)keyContainers.get(0)).containsKey(entityId)) {
            this.log.trace("No locally trusted keys found for {}", (Object)entityId);
            return false;
        }
        return true;
    }

    private boolean isTrustAnchor(@Nonnull String entityId, @Nonnull List<List<EntityStatement>> trustChains) {
        return trustChains.stream().filter(chain -> entityId.equals(((EntityStatement)chain.get(chain.size() - 1)).getEntityID().getValue())).findAny().isPresent();
    }

    @Nonnull
    @NonnullElements
    private List<List<EntityStatement>> populateChain(@Nonnull @NonnullElements List<List<EntityStatement>> entities, @Nonnull List<String> preSelectedChain) {
        ArrayList<List<EntityStatement>> result = new ArrayList<List<EntityStatement>>();
        boolean hints = false;
        for (List<EntityStatement> chain : entities) {
            EntityStatement entityStatement = chain.get(chain.size() - 1);
            List authorityHints = entityStatement.getClaimsSet().getAuthorityHints();
            if (authorityHints == null || authorityHints.isEmpty()) {
                result.add(chain);
                continue;
            }
            List<Pair> authorities = authorityHints.stream().map(Identifier::getValue).filter(id -> preSelectedChain.isEmpty() || preSelectedChain.contains(id)).map(id -> this.fetchAuthority(entityStatement, (String)id)).filter(pair -> pair != null && pair.getFirst() != null && pair.getSecond() != null).filter(pair -> FederationPolicyConstraintHelper.verifyPolicyConstraints(this.objectMapper, (EntityStatement)pair.getSecond(), chain, this.federationPolicyConstraints)).toList();
            hints = !authorities.isEmpty();
            authorities.forEach(authority -> {
                ArrayList<EntityStatement> newChain = new ArrayList<EntityStatement>(chain);
                newChain.add((EntityStatement)authority.getSecond());
                newChain.add((EntityStatement)authority.getFirst());
                result.add(newChain);
            });
        }
        if (hints) {
            return this.populateChain(result, preSelectedChain);
        }
        return result;
    }

    @Nullable
    protected Pair<EntityStatement, EntityStatement> fetchAuthority(@Nonnull EntityStatement entity, @Nullable String authorityHint) {
        String entityId = entity.getEntityID().getValue();
        if (entityId == null || authorityHint == null) {
            this.log.error("Entity ID ({}) or authority hint ({}) may not be null", (Object)entityId, (Object)authorityHint);
            return null;
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(entityId), new IssuerEntityIDCriterion(authorityHint)});
        try {
            EntityStatement authorityConfiguration = this.getFirstIfFound(this.entityConfigurationCache.get(new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(authorityHint)})));
            EntityStatement metadata = this.getFirstIfFound(this.subordinateStatementCache.get(criteria));
            return new Pair((Object)authorityConfiguration, (Object)metadata);
        }
        catch (MetadataCacheException e) {
            this.log.error("Could not resolve authority hint {} for {}", (Object)authorityHint, (Object)entityId);
            return null;
        }
    }

    @Nullable
    private EntityStatement getFirstIfFound(@Nonnull List<EntityStatement> statements) {
        return statements.size() > 0 ? statements.get(0) : null;
    }
}

