/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.ExpirationTimeContext;

@ThreadSafe
public class DefaultTrustChainExpirationTimeStrategy
implements Function<ExpirationTimeContext<List<List<EntityStatement>>>, Instant> {
    @Override
    @Nullable
    public Instant apply(@Nullable ExpirationTimeContext<List<List<EntityStatement>>> context) {
        if (context == null) {
            return null;
        }
        Instant contextExpiration = context.getNow().plus(context.getMaxCacheDuration());
        List chains = (List)context.getMetadata();
        if (chains == null || chains.isEmpty()) {
            return contextExpiration;
        }
        Instant metadataExpiration = null;
        for (List chain : chains) {
            for (EntityStatement statement : chain) {
                Instant statementExpiration = statement.getClaimsSet().getExpirationTime().toInstant();
                metadataExpiration = metadataExpiration == null ? statementExpiration : (statementExpiration.isBefore(metadataExpiration) ? statementExpiration : metadataExpiration);
            }
        }
        if (metadataExpiration == null) {
            return contextExpiration;
        }
        return metadataExpiration.isBefore(contextExpiration) ? metadataExpiration : contextExpiration;
    }
}

