/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultSubordinateStatementEndpointExtractionStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, URI> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultSubordinateStatementEndpointExtractionStrategy.class);
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;
    @NonnullAfterInit
    private Function<CriteriaSet, String> criteriaToSubjectEntityIdStrategy;
    @NonnullAfterInit
    private Function<CriteriaSet, String> criteriaToIssuerEntityIdStrategy;

    public void setCriteriaToSubjectEntityIdStrategy(@Nonnull Function<CriteriaSet, String> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToSubjectEntityIdStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to subject entity ID strategy cannot be null");
    }

    public void setCriteriaToIssuerEntityIdStrategy(@Nonnull Function<CriteriaSet, String> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToIssuerEntityIdStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to issuer entity ID strategy cannot be null");
    }

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity Configuration cache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.criteriaToSubjectEntityIdStrategy == null) {
            throw new ComponentInitializationException("Criteria to subject entity ID strategy cannot be null");
        }
        if (this.criteriaToIssuerEntityIdStrategy == null) {
            throw new ComponentInitializationException("Criteria to issuer entity ID strategy cannot be null");
        }
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity Configuration cache cannot be null");
        }
    }

    @Override
    @Nullable
    public URI apply(@Nullable CriteriaSet criteria) {
        URI federationFetchEndpoint;
        List issuerStatements;
        this.checkComponentActive();
        String subjectEntityId = this.criteriaToSubjectEntityIdStrategy.apply(criteria);
        if (subjectEntityId == null) {
            return null;
        }
        String issuerEntityId = this.criteriaToIssuerEntityIdStrategy.apply(criteria);
        if (issuerEntityId == null) {
            return null;
        }
        try {
            issuerStatements = this.entityConfigurationCache.get(new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(issuerEntityId)}));
        }
        catch (MetadataCacheException e) {
            this.log.error("Could not resolve entity configuration for issuer {}", (Object)issuerEntityId, (Object)e);
            return null;
        }
        if (issuerStatements.isEmpty()) {
            this.log.error("Could not resolve entity configuration for issuer {}", (Object)issuerEntityId);
            return null;
        }
        FederationEntityMetadata issuerMetadata = ((EntityStatement)issuerStatements.get(0)).getClaimsSet().getFederationEntityMetadata();
        URI uRI = federationFetchEndpoint = issuerMetadata != null ? issuerMetadata.getFederationFetchEndpointURI() : null;
        if (federationFetchEndpoint == null) {
            this.log.warn("No federation fetch endpoint found from the entity configuration for {}", (Object)issuerEntityId);
            return null;
        }
        try {
            return new URI(String.valueOf(federationFetchEndpoint) + "?sub=" + subjectEntityId);
        }
        catch (URISyntaxException e) {
            this.log.error("Could not build URI for fetching subordinate entity statement", (Throwable)e);
            return null;
        }
    }
}

