/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.AbstractFederationEndpointResponseFetchingStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultResolveEntityTrustChainFetchingStrategy
extends AbstractFederationEndpointResponseFetchingStrategy<ResolveEntityRequest, ResolveEntityResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultResolveEntityTrustChainFetchingStrategy.class);

    public DefaultResolveEntityTrustChainFetchingStrategy() {
        this.setCriteriaToRequestStrategy(criteria -> {
            ResolveEntityRequestCriterion requestCriterion = (ResolveEntityRequestCriterion)criteria.get(ResolveEntityRequestCriterion.class);
            if (requestCriterion == null) {
                this.log.debug("No request criterion given, returning null");
                return null;
            }
            return requestCriterion.getRequest();
        });
    }

    @Override
    @Nullable
    protected ClassicHttpRequest initializeHttpRequest(@Nonnull CriteriaSet criteria, @Nonnull ResolveEntityRequest resolveRequest) {
        URI uri;
        HttpGet httpRequest = new HttpGet(resolveRequest.getEndpointURI());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("sub", resolveRequest.getSubject()));
        resolveRequest.getTrustAnchors().forEach(trustAnchor -> nvps.add(new BasicNameValuePair("trust_anchor", trustAnchor)));
        resolveRequest.getEntityTypes().forEach(entityType -> nvps.add(new BasicNameValuePair("entity_type", entityType)));
        try {
            uri = new URIBuilder(httpRequest.getUri()).addParameters(nvps).build();
        }
        catch (URISyntaxException e) {
            this.log.error("Could not build endpoint URI for the resolve entity request", (Throwable)e);
            return null;
        }
        this.log.debug("Using URI {} for fetching resolve entity API response", (Object)uri);
        httpRequest.setHeader("Content-Type", (Object)ContentType.APPLICATION_FORM_URLENCODED);
        httpRequest.setUri(uri);
        return httpRequest;
    }

    @Override
    @Nullable
    protected ResolveEntityResponseContainer parseHttpResponse(@Nonnull CriteriaSet criteria, @Nonnull ResolveEntityRequest request, @Nullable ClassicHttpResponse response) throws ProtocolException, IOException {
        ResponseContainerExpirationCriterion expirationCriterion = (ResponseContainerExpirationCriterion)criteria.get(ResponseContainerExpirationCriterion.class);
        if (expirationCriterion == null) {
            this.log.debug("No expiration criterion given, returning null");
            return null;
        }
        if (response != null) {
            HTTPResponse nimbusResponse = new HTTPResponse(response.getCode());
            nimbusResponse.setContent(EntityUtils.toString((HttpEntity)response.getEntity()));
            try {
                nimbusResponse.setContentType(response.getEntity().getContentType());
                ResolveEntityResponse resolveResponse = ResolveEntityResponse.parse(nimbusResponse);
                Instant expirationTime = expirationCriterion.getExpirationInstant();
                return new ResolveEntityResponseContainer(resolveResponse, request, expirationTime);
            }
            catch (ParseException e) {
                this.log.warn("Could not parse resolve entity response from URI: {}", (Object)request.getEndpointURI(), (Object)e);
            }
        } else {
            this.log.debug("Unable to fetch resolve entity response from URI: {} (null response)", (Object)request.getEndpointURI());
        }
        return null;
    }
}

