/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultResolveEntityResponseFetchingStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, ResolveEntityResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultResolveEntityResponseFetchingStrategy.class);

    @Override
    @Nullable
    public ResolveEntityResponseContainer apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        if (criteria == null) {
            return null;
        }
        ResolveEntityRequestCriterion requestCriterion = (ResolveEntityRequestCriterion)criteria.get(ResolveEntityRequestCriterion.class);
        if (requestCriterion == null) {
            this.log.debug("No request criterion given, returning null");
            return null;
        }
        NimbusResponseCriterion responseCriterion = (NimbusResponseCriterion)criteria.get(NimbusResponseCriterion.class);
        if (responseCriterion == null) {
            this.log.debug("No response criterion given, returning null");
            return null;
        }
        ResponseContainerExpirationCriterion expirationCriterion = (ResponseContainerExpirationCriterion)criteria.get(ResponseContainerExpirationCriterion.class);
        if (expirationCriterion == null) {
            this.log.debug("No expiration criterion given, returning null");
            return null;
        }
        return new ResolveEntityResponseContainer(responseCriterion.getResponse(), requestCriterion.getRequest(), expirationCriterion.getExpirationInstant());
    }
}

