/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraint;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraintHelper;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultProvidedTrustChainValidationStrategy
extends AbstractIdentifiableInitializableComponent
implements BiPredicate<ProfileRequestContext, List<EntityStatement>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultProvidedTrustChainValidationStrategy.class);
    @NonnullAfterInit
    BiFunction<List<List<EntityStatement>>, MetadataFilterContext, List<List<EntityStatement>>> trustChainSignatureValidationFilterStrategy;
    @NonnullAfterInit
    private Map<String, FederationPolicyConstraint> federationPolicyConstraints;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setTrustChainSignatureValidationFilterStrategy(@Nonnull BiFunction<List<List<EntityStatement>>, MetadataFilterContext, List<List<EntityStatement>>> strategy) {
        this.checkSetterPreconditions();
        this.trustChainSignatureValidationFilterStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"TrustChainSignatureValidationFilterStrategy cannot be null");
    }

    public void setfederationPolicyConstraints(@Nonnull Map<String, FederationPolicyConstraint> constraints) {
        this.checkSetterPreconditions();
        this.federationPolicyConstraints = (Map)Constraint.isNotNull(constraints, (String)"Map of policy constraints cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.trustChainSignatureValidationFilterStrategy == null) {
            throw new ComponentInitializationException("TrustChainSignatureValidationFilterStrategy cannot be null");
        }
        if (this.federationPolicyConstraints == null) {
            throw new ComponentInitializationException("Map of policy constraints cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext profileRequestContext, @Nullable List<EntityStatement> trustChain) {
        this.checkComponentActive();
        if (trustChain == null || trustChain.size() < 3 || trustChain.contains(null)) {
            this.log.error("No satisfactory trust chain provided");
            return false;
        }
        List<List<EntityStatement>> validatedChains = this.trustChainSignatureValidationFilterStrategy.apply(List.of(trustChain), null);
        if (validatedChains == null || validatedChains.size() != 1) {
            this.log.debug("The trust chain did not pass the signature validation");
            return false;
        }
        for (int i = 1; i < trustChain.size() - 1; ++i) {
            if (FederationPolicyConstraintHelper.verifyPolicyConstraints(this.objectMapper, trustChain.get(i), trustChain.subList(0, i), this.federationPolicyConstraints)) continue;
            this.log.debug("Subordinate statement {} policy constraints validation failed", (Object)trustChain.get(i).getEntityID());
            return false;
        }
        return true;
    }
}

