/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SignatureValidationKeyContainerJwtCriterion;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class DefaultPayloadSignatureValidationCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultPayloadSignatureValidationCredentialResolver.class);

    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        if (criteriaSet == null || !criteriaSet.contains(SignatureValidationKeyContainerJwtCriterion.class)) {
            throw new ResolverException("CriteriaSet does not contain SignatureValidationKeyContainerJwtCriterion");
        }
        SignatureValidationKeyContainerJwtCriterion keyContainer = (SignatureValidationKeyContainerJwtCriterion)criteriaSet.get(SignatureValidationKeyContainerJwtCriterion.class);
        SignedJWT jwt = keyContainer.getJwt();
        if (jwt == null) {
            throw new ResolverException("SignatureValidationKeyContainerJwtCriterion did not contain an instance of SignedJWT");
        }
        try {
            Map rawJwks = jwt.getJWTClaimsSet().getJSONObjectClaim("jwks");
            if (rawJwks == null || rawJwks.isEmpty()) {
                this.log.debug("No jwks found from the payload");
                return CollectionSupport.emptyList();
            }
            JWKSet jwks = JWKSet.parse((Map)rawJwks);
            return jwks.getKeys().stream().filter(Objects::nonNull).map(jwk -> this.buildJWKCredential((JWK)jwk, null)).filter(Objects::nonNull).map(Credential.class::cast).toList();
        }
        catch (ParseException e) {
            throw new ResolverException("Could not parse JWKSet from JOSEObject", (Exception)e);
        }
    }
}

