/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.openid.connect.sdk.federation.config.FederationEntityConfigurationSuccessResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseContainer;
import net.shibboleth.oidc.metadata.cache.ExpirationTimeContext;

@ThreadSafe
public class DefaultNimbusResponseContainerExpirationTimeStrategy
implements Function<ExpirationTimeContext<NimbusResponseContainer>, Instant> {
    @Override
    @Nullable
    public Instant apply(@Nullable ExpirationTimeContext<NimbusResponseContainer> context) {
        if (context == null) {
            return null;
        }
        Instant contextExpiration = context.getNow().plus(context.getMaxCacheDuration());
        NimbusResponseContainer container = (NimbusResponseContainer)context.getMetadata();
        if (container == null || container.getExpirationInstant() == null) {
            return contextExpiration;
        }
        ArrayList<Instant> expirations = new ArrayList<Instant>(List.of(contextExpiration, container.getExpirationInstant()));
        Response response = container.getResponse();
        if (response instanceof FederationEntityConfigurationSuccessResponse) {
            FederationEntityConfigurationSuccessResponse successResponse = (FederationEntityConfigurationSuccessResponse)response;
            Optional.ofNullable(successResponse.getEntityStatement().getClaimsSet().getExpirationTime()).map(date -> date.toInstant()).ifPresent(instant -> expirations.add((Instant)instant));
        }
        return Collections.min(expirations);
    }
}

