/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jose.jwk.JWKSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class DefaultLocalTrustAnchorsValidator
implements Predicate<Map<String, LocalKeyContainer>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultLocalTrustAnchorsValidator.class);

    @Override
    public boolean test(@Nullable Map<String, LocalKeyContainer> keyContainers) {
        if (keyContainers == null) {
            return false;
        }
        for (String anchor : keyContainers.keySet()) {
            JWKSet jwkSet;
            LocalKeyContainer container = keyContainers.get(anchor);
            if (container == null || (jwkSet = container.getJWKSet()) == null || !jwkSet.containsNonPublicKeys()) continue;
            this.log.warn("Not accepting keyset for {} as it contains non-public keys", (Object)anchor);
            return false;
        }
        return true;
    }
}

