/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.AbstractEntityStatementSignatureValidationComponent;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultEntityStatementSignatureValidationFilterStrategy
extends AbstractEntityStatementSignatureValidationComponent
implements BiFunction<EntityStatement, MetadataFilterContext, EntityStatement> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEntityStatementSignatureValidationFilterStrategy.class);

    @Override
    @Nullable
    public EntityStatement apply(@Nullable EntityStatement entityStatement, @Nullable MetadataFilterContext filterContext) {
        this.checkComponentActive();
        if (entityStatement == null) {
            return null;
        }
        String entityId = entityStatement.getEntityID().getValue();
        this.log.trace("Starting signature validation of entity statement for {}", (Object)entityId);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityStatementCriterion(entityStatement)});
        if (this.validateStatement(entityStatement, criteria, entityId)) {
            return entityStatement;
        }
        return null;
    }
}

