/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultEntityStatementFetchingStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, EntityStatement> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEntityStatementFetchingStrategy.class);
    @NonnullAfterInit
    protected HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private Function<CriteriaSet, URI> criteriaToEndpointStrategy;

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    public void setCriteriaToEndpointStrategy(@Nonnull Function<CriteriaSet, URI> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToEndpointStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to endpoint strategy cannot be null");
    }

    @Nonnull
    protected HttpClientContext buildHttpContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
        return clientContext;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("Httpclient cannot be null");
        }
        if (this.criteriaToEndpointStrategy == null) {
            throw new ComponentInitializationException("Criteria to endpoint strategy cannot be null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public EntityStatement apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        URI uri = this.criteriaToEndpointStrategy.apply(criteria);
        if (uri == null || StringSupport.trimOrNull((String)uri.getScheme()) == null) {
            this.log.error("No valid URI could be resolved for fetching entity statement: {}", (Object)uri);
            return null;
        }
        this.log.debug("Using URI {} for fetching entity statement", (Object)uri);
        HttpGet httpRequest = new HttpGet(uri);
        HttpClientContext httpContext = this.buildHttpContext((ClassicHttpRequest)httpRequest);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpRequest, (HttpContext)httpContext);){
            String scheme = httpRequest.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)scheme);
            if (response != null && response.getCode() == 200) {
                HttpEntity responseEntity = response.getEntity();
                if (!"application/entity-statement+jwt".equals(responseEntity.getContentType())) {
                    this.log.warn("Unexpected response content type {} from URI {}", (Object)responseEntity.getContentType(), (Object)uri);
                    EntityStatement entityStatement = null;
                    return entityStatement;
                }
                EntityStatement entityStatement = EntityStatementHelper.deserializeEntityStatement(EntityUtils.toString((HttpEntity)response.getEntity()));
                String type = Optional.ofNullable(entityStatement).map(statement -> statement.getSignedStatement().getHeader().getType()).map(header -> header.getType()).orElse(null);
                if (!"entity-statement+jwt".equals(type)) {
                    this.log.warn("Ignoring entity statement with unexpected type {}", (Object)type);
                    EntityStatement entityStatement2 = null;
                    return entityStatement2;
                }
                EntityStatement entityStatement3 = entityStatement;
                return entityStatement3;
            }
            this.log.debug("Unable to fetch entity configuration from URI: {} (HTTP status {})", (Object)uri, response == null ? null : Integer.valueOf(response.getCode()));
            EntityStatement entityStatement = null;
            return entityStatement;
        }
        catch (IOException | URISyntaxException | ParseException e) {
            this.log.debug("Unable to fetch entity statement from URI: {}", (Object)uri, (Object)e);
            return null;
        }
    }
}

