/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.ExpirationTimeContext;

@ThreadSafe
public class DefaultEntityStatementExpirationTimeStrategy
implements Function<ExpirationTimeContext<EntityStatement>, Instant> {
    @Override
    @Nullable
    public Instant apply(@Nullable ExpirationTimeContext<EntityStatement> context) {
        if (context == null) {
            return null;
        }
        Instant contextExpiration = context.getNow().plus(context.getMaxCacheDuration());
        EntityStatement statement = (EntityStatement)context.getMetadata();
        if (statement == null) {
            return contextExpiration;
        }
        Instant metadataExpiration = statement.getClaimsSet().getExpirationTime().toInstant();
        return metadataExpiration.isBefore(contextExpiration) ? metadataExpiration : contextExpiration;
    }
}

