/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultEntityStatementContentValidationFilterStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<EntityStatement, EntityStatement> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEntityStatementContentValidationFilterStrategy.class);
    @NonnullAfterInit
    private ClaimsValidator claimsValidator;

    public void setClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.checkSetterPreconditions();
        this.claimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Claims validator cannot be null");
    }

    @Override
    @Nullable
    public EntityStatement apply(@Nullable EntityStatement entityStatement) {
        this.checkComponentActive();
        if (entityStatement == null) {
            return null;
        }
        String entityId = entityStatement.getEntityID().getValue();
        try {
            this.claimsValidator.validate(entityStatement.getSignedStatement().getJWTClaimsSet(), null);
        }
        catch (ParseException | JWTValidationException e) {
            this.log.warn("Claims validation failed for entity configuration {}", (Object)entityId, (Object)e);
            return null;
        }
        this.log.debug("Entity configuration {} claims successfully validated", (Object)entityId);
        return entityStatement;
    }
}

