/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultEntityConfigurationEndpointExtractionStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, URI> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEntityConfigurationEndpointExtractionStrategy.class);
    @NonnullAfterInit
    private Function<CriteriaSet, String> criteriaToEntityIdStrategy;

    public void setCriteriaToEntityIdStrategy(@Nonnull Function<CriteriaSet, String> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToEntityIdStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to entity ID strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.criteriaToEntityIdStrategy == null) {
            throw new ComponentInitializationException("Criteria to entity ID strategy cannot be null");
        }
    }

    @Override
    @Nullable
    public URI apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        String entityId = this.criteriaToEntityIdStrategy.apply(criteria);
        if (entityId == null) {
            return null;
        }
        try {
            return new URI(entityId + (entityId.endsWith("/") ? "" : "/") + ".well-known/openid-federation");
        }
        catch (URISyntaxException e) {
            this.log.error("Could not build URI for entity configuration endpoint", (Throwable)e);
            return null;
        }
    }
}

