/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultCombinedMetadataFromTrustChainLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<List<EntityStatement>, Map<String, Map<String, Object>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultCombinedMetadataFromTrustChainLookupStrategy.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, Map<String, Object>> apply(@Nullable List<EntityStatement> chain) {
        if (chain == null || chain.size() < 3) {
            this.log.warn("Unexpected trust chain input: {}", chain == null ? null : "size = " + chain.size());
            return null;
        }
        Map<String, Map<String, Object>> configurationMetadata = EntityStatementHelper.parseMetadata(this.objectMapper, chain.get(0));
        Map<String, Map<String, Object>> subordinateMetadata = EntityStatementHelper.parseMetadata(this.objectMapper, chain.get(1));
        if (configurationMetadata == null || configurationMetadata.isEmpty()) {
            this.log.error("Entity configuration for {} doesn't contain metadata", (Object)chain.get(0).getEntityID().getValue());
            return null;
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (String entityType : configurationMetadata.keySet()) {
            Map<String, Object> configurationClaims = configurationMetadata.get(entityType);
            HashMap<String, Object> subordinateClaims = new HashMap<String, Object>(Optional.ofNullable(subordinateMetadata).map(metadata -> (Map)metadata.get(entityType)).orElse(CollectionSupport.emptyMap()));
            for (String configurationClaim : configurationClaims.keySet()) {
                if (!subordinateClaims.containsKey(configurationClaim)) {
                    this.log.trace("Including metadata claim {} from the entity configuration", (Object)configurationClaim);
                    subordinateClaims.put(configurationClaim, configurationClaims.get(configurationClaim));
                    continue;
                }
                this.log.trace("Keeping metadata claim {} from the subordinate configuration", (Object)configurationClaim);
            }
            result.put(entityType, subordinateClaims);
        }
        return result;
    }
}

