/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;

public class AbstractTrustEngineSignatureValidationComponent
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractTrustEngineSignatureValidationComponent.class);
    @NonnullAfterInit
    private TrustEngine<SignedJWT> trustEngine;
    @Nullable
    private CriteriaSet defaultCriteria;

    public void setTrustEngine(@Nonnull TrustEngine<SignedJWT> engine) {
        this.checkSetterPreconditions();
        this.trustEngine = (TrustEngine)Constraint.isNotNull(engine, (String)"Trust Engine cannot be null");
    }

    public void setDefaultCriteria(@Nullable CriteriaSet criteria) {
        this.checkSetterPreconditions();
        this.defaultCriteria = criteria;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.trustEngine == null) {
            throw new ComponentInitializationException("Trust Engine cannot be null");
        }
    }

    protected boolean validateJwt(@Nonnull SignedJWT jwt, @Nonnull CriteriaSet criteria, @Nullable String entityId) {
        if (this.defaultCriteria != null && !this.defaultCriteria.isEmpty()) {
            criteria.addAll((Collection)this.defaultCriteria);
        }
        try {
            if (this.trustEngine.validate((Object)jwt, criteria)) {
                this.log.debug("Successfully validated entity statement for {}", (Object)entityId);
                return true;
            }
            this.log.warn("Trust Engine validation failed for {}, issued by {}", (Object)entityId, (Object)jwt.getJWTClaimsSet().getIssuer());
        }
        catch (ParseException | SecurityException e) {
            this.log.warn("Could not validate entity statement for {}", (Object)entityId, (Object)e);
        }
        return false;
    }
}

