/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.Request;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseContainer;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

public abstract class AbstractFederationEndpointResponseFetchingStrategy<R extends Request, C extends NimbusResponseContainer>
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, C> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractFederationEndpointResponseFetchingStrategy.class);
    @NonnullAfterInit
    protected HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullAfterInit
    private Function<CriteriaSet, R> criteriaToRequestStrategy;

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    public void setCriteriaToRequestStrategy(@Nonnull Function<CriteriaSet, R> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToRequestStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to request strategy cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("Httpclient cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
        if (this.criteriaToRequestStrategy == null) {
            throw new ComponentInitializationException("Criteria to request strategy cannot be null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public C apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        if (criteria == null) {
            this.log.error("No criteria set provided");
            return null;
        }
        Request request = (Request)this.criteriaToRequestStrategy.apply(criteria);
        if (request == null) {
            this.log.debug("Could not resolve request from criteria {}", (Object)criteria);
            return null;
        }
        ClassicHttpRequest httpRequest = this.initializeHttpRequest(criteria, request);
        if (httpRequest == null) {
            this.log.debug("Could not initialize HTTP request from {}", (Object)request);
            return null;
        }
        HttpClientContext httpContext = this.buildHttpContext(httpRequest);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, httpRequest, (HttpContext)httpContext);){
            String scheme = httpRequest.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)scheme);
            C c = this.parseHttpResponse(criteria, request, response);
            return c;
        }
        catch (IOException | URISyntaxException | ProtocolException e) {
            this.log.debug("Unable to fetch resolve entity response from URI: {}", (Object)request.getEndpointURI(), (Object)e);
            return null;
        }
    }

    @Nonnull
    protected HttpClientContext buildHttpContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
        return clientContext;
    }

    @Nullable
    protected abstract ClassicHttpRequest initializeHttpRequest(@Nonnull CriteriaSet var1, @Nonnull R var2);

    @Nullable
    protected abstract C parseHttpResponse(@Nonnull CriteriaSet var1, @Nonnull R var2, @Nullable ClassicHttpResponse var3) throws ProtocolException, IOException;
}

