/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.net.URI;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class TrustMarkRequest
implements Request {
    @Nonnull
    private final URI endpointUri;
    @Nonnull
    @NotEmpty
    private final String trustMarkType;
    @Nonnull
    @NotEmpty
    private final String subject;

    public TrustMarkRequest(@Nonnull URI uri, @Nonnull String type, @Nonnull String sub) {
        this.endpointUri = (URI)Constraint.isNotNull((Object)uri, (String)"Endpoint URI cannot be null");
        this.trustMarkType = Constraint.isNotEmpty((String)type, (String)"Trust Mark type cannot be null or empty");
        this.subject = Constraint.isNotEmpty((String)sub, (String)"Subject cannot be null or empty");
    }

    @Nonnull
    public URI getEndpointURI() {
        return this.endpointUri;
    }

    public HTTPRequest toHTTPRequest() {
        return null;
    }

    @Nonnull
    @NotEmpty
    public String getTrustMarkType() {
        return this.trustMarkType;
    }

    @Nonnull
    @NotEmpty
    public String getSubject() {
        return this.subject;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subject", (Object)this.getSubject()).add("trustMarkType", (Object)this.getTrustMarkType()).add("endpointURI", (Object)this.getEndpointURI()).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrustMarkRequest other = (TrustMarkRequest)obj;
        return this.endpointUri.equals(other.endpointUri) && this.subject.equals(other.subject) && this.trustMarkType.equals(other.trustMarkType);
    }
}

