/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;

public class ResolveEntityRequest
implements Request {
    @Nonnull
    private final URI endpointUri;
    @Nonnull
    @NotEmpty
    private final String subject;
    @Nonnull
    @NotEmpty
    private final List<String> trustAnchors;
    @Nonnull
    private final List<String> entityTypes;

    public ResolveEntityRequest(@Nonnull URI uri, @Nonnull @NotEmpty String sub, @Nonnull @NotEmpty List<String> anchors, @Nullable List<String> types) {
        this.endpointUri = (URI)Constraint.isNotNull((Object)uri, (String)"Endpoint URI cannot be null");
        this.subject = (String)Constraint.isNotNull((Object)sub, (String)"Subject cannot be empty");
        Constraint.isNotEmpty(anchors, (String)"Trust anchors cannot be empty");
        this.trustAnchors = anchors;
        this.entityTypes = types == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(types);
    }

    @Nonnull
    @NotEmpty
    public String getSubject() {
        return this.subject;
    }

    @Nonnull
    @NotEmpty
    public List<String> getTrustAnchors() {
        return this.trustAnchors;
    }

    @Nonnull
    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    @Nonnull
    public URI getEndpointURI() {
        return this.endpointUri;
    }

    public HTTPRequest toHTTPRequest() {
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subject", (Object)this.getSubject()).add("trustAnchors", this.getTrustAnchors()).add("entityTypes", this.getEntityTypes()).add("endpointURI", (Object)this.getEndpointURI()).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolveEntityRequest other = (ResolveEntityRequest)obj;
        return this.endpointUri.equals(other.endpointUri) && this.subject.equals(other.subject) && this.entityTypes.containsAll(other.entityTypes) && other.entityTypes.containsAll(this.entityTypes) && this.trustAnchors.containsAll(other.trustAnchors) && other.trustAnchors.containsAll(this.trustAnchors);
    }
}

