/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.AbstractSignedJWTResponse;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.StringSupport;

public class ExplicitClientRegistrationResponse
extends AbstractSignedJWTResponse {
    @Nonnull
    public static final JOSEObjectType JWT_TYPE_HEADER = new JOSEObjectType("explicit-registration-response+jwt");
    @Nonnull
    public static final ContentType HTTP_RESPONSE_CONTENT_TYPE = new ContentType("application", JWT_TYPE_HEADER.toString(), new ContentType.Parameter[0]);

    public ExplicitClientRegistrationResponse(@Nonnull SignedJWT statement) {
        super(statement);
    }

    @Override
    protected ContentType getHttpResponseContentType() {
        return HTTP_RESPONSE_CONTENT_TYPE;
    }

    @Override
    protected JOSEObjectType getJWTTypeHeader() {
        return JWT_TYPE_HEADER;
    }

    @Nonnull
    public static ExplicitClientRegistrationResponse parse(@Nonnull HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(new int[]{200});
        httpResponse.ensureEntityContentType(HTTP_RESPONSE_CONTENT_TYPE);
        String content = httpResponse.getContent();
        if (StringSupport.trimOrNull((String)content) == null) {
            throw new ParseException("Message body is empty");
        }
        try {
            SignedJWT jwt = SignedJWT.parse((String)httpResponse.getContent());
            return new ExplicitClientRegistrationResponse(jwt);
        }
        catch (java.text.ParseException | ConstraintViolationException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

