/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class ExplicitClientRegistrationRequest
implements Request {
    @Nonnull
    private final URI endpointUri;
    @Nullable
    private final EntityStatement entityConfiguration;
    @Nullable
    private final List<EntityStatement> trustChain;

    public ExplicitClientRegistrationRequest(@Nonnull URI uri, @Nonnull EntityStatement configuration) {
        this.endpointUri = (URI)Constraint.isNotNull((Object)uri, (String)"Endpoint URI cannot be null");
        this.entityConfiguration = (EntityStatement)Constraint.isNotNull((Object)configuration, (String)"Entity configuration cannot be null");
        this.trustChain = null;
    }

    public ExplicitClientRegistrationRequest(@Nonnull URI uri, @Nonnull @NotEmpty List<EntityStatement> chain) {
        this.endpointUri = (URI)Constraint.isNotNull((Object)uri, (String)"Endpoint URI cannot be null");
        Constraint.isNotEmpty(chain, (String)"Trust chain cannot be empty");
        this.trustChain = chain;
        this.entityConfiguration = null;
    }

    @Nonnull
    public URI getEndpointURI() {
        return this.endpointUri;
    }

    public HTTPRequest toHTTPRequest() {
        return null;
    }

    @Nullable
    public EntityStatement getEntityConfiguration() {
        return this.entityConfiguration;
    }

    @Nullable
    public List<EntityStatement> getTrustChain() {
        return this.trustChain;
    }
}

