/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;

public abstract class AbstractSignedJWTResponse
implements Response {
    @Nonnull
    private final SignedJWT jwt;

    public AbstractSignedJWTResponse(@Nonnull SignedJWT statement) {
        this.jwt = (SignedJWT)Constraint.isNotNull((Object)statement, (String)"Entity statement cannot be null");
        JOSEObjectType type = this.jwt.getHeader().getType();
        if (!this.getJWTTypeHeader().equals((Object)type)) {
            throw new ConstraintViolationException("Unexcepted type header (" + String.valueOf(type) + "), expected " + String.valueOf(this.getJWTTypeHeader()));
        }
    }

    @Nonnull
    public SignedJWT getJWT() {
        return this.jwt;
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(this.getHttpResponseContentType());
        httpResponse.setContent(this.getJWT().serialize());
        return httpResponse;
    }

    @Nonnull
    protected abstract ContentType getHttpResponseContentType();

    @Nonnull
    protected abstract JOSEObjectType getJWTTypeHeader();
}

