/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class ResolveEntityRequestDecoder
extends BaseOAuth2RequestDecoder<ResolveEntityRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResolveEntityRequestDecoder.class);

    protected ResolveEntityRequest parseMessage() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        assert (request != null);
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP GET method");
        }
        try {
            HTTPRequest httpRequest = JakartaServletUtils.createHTTPRequest((HttpServletRequest)request);
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString((HTTPRequest)httpRequest, null));
            URI uri = httpRequest.getURI();
            if (uri == null) {
                throw new MessageDecodingException("Could not parse request URI");
            }
            Map parameters = httpRequest.getQueryParameters();
            String subject = Optional.ofNullable((List)parameters.get("sub")).filter(Objects::nonNull).filter(list -> list.size() == 1).map(list -> (String)list.get(0)).orElse(null);
            if (subject == null) {
                throw new MessageDecodingException("No single sub value in the request");
            }
            List trustAnchors = Optional.ofNullable((List)parameters.get("trust_anchor")).filter(Objects::nonNull).filter(list -> list.size() > 0).orElse(null);
            if (trustAnchors == null) {
                throw new MessageDecodingException("No trust_anchor included in the request");
            }
            return new ResolveEntityRequest(uri, subject, trustAnchors, (List)parameters.get("entity_type"));
        }
        catch (IOException e) {
            this.log.error("Could not create HTTP request from the request", (Throwable)e);
            throw new MessageDecodingException((Exception)e);
        }
    }

    protected String getMessageToLog(@Nullable ResolveEntityRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("subject", (Object)message.getSubject()).add("trustAnchors", message.getTrustAnchors()).add("entityTypes", message.getEntityTypes()).add("endpointURI", (Object)this.getEndpointURI(message)).toString();
    }
}

