/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.decoding.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ExplicitClientRegistrationRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class ExplicitClientRegistrationRequestDecoder
extends BaseOAuth2RequestDecoder<ExplicitClientRegistrationRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExplicitClientRegistrationRequestDecoder.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    protected ExplicitClientRegistrationRequest parseMessage() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        assert (request != null);
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        try {
            HTTPRequest httpRequest = JakartaServletUtils.createHTTPRequest((HttpServletRequest)request);
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString((HTTPRequest)httpRequest, (ObjectMapper)this.objectMapper));
            URI uri = httpRequest.getURI();
            if (uri == null) {
                throw new MessageDecodingException("Could not parse request URI");
            }
            String contentType = request.getContentType();
            if ("application/entity-statement+jwt".equals(contentType)) {
                EntityStatement entityConfiguration = EntityStatementHelper.deserializeEntityStatement(httpRequest.getQuery());
                if (entityConfiguration == null) {
                    throw new MessageDecodingException("Could not deserialize entity configuration");
                }
                this.log.trace("Entity configuration claims set: {}", (Object)entityConfiguration.getClaimsSet());
                return new ExplicitClientRegistrationRequest(uri, entityConfiguration);
            }
            if ("application/trust-chain+json".equals(contentType)) {
                TypeReference<List<String>> typeReference = new TypeReference<List<String>>(){};
                List strings = (List)this.objectMapper.readValue(httpRequest.getQuery(), (TypeReference)typeReference);
                List<EntityStatement> trustChain = strings.stream().map(string -> EntityStatementHelper.deserializeEntityStatement(string)).filter(Objects::nonNull).toList();
                if (trustChain == null || trustChain.isEmpty()) {
                    throw new MessageDecodingException("Could not deserialize trust chain");
                }
                return new ExplicitClientRegistrationRequest(uri, trustChain);
            }
            this.log.warn("Unexpected content type {}", (Object)contentType);
            throw new MessageDecodingException("Unexpected content type: " + contentType);
        }
        catch (IOException e) {
            this.log.error("Could not create HTTP request from the request", (Throwable)e);
            throw new MessageDecodingException((Exception)e);
        }
    }

    protected String getMessageToLog(@Nullable ExplicitClientRegistrationRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("entityConfiguration", (Object)EntityStatementHelper.getSerializedEntityStatement(message.getEntityConfiguration())).add("trustChain", (Object)EntityStatementHelper.getSerializedTrustChain(message.getTrustChain())).add("endpointURI", (Object)this.getEndpointURI(message)).toString();
    }
}

