/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ExplicitClientRegistrationRequest;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class ExplicitClientRegistrationRequestJWKSetLookupFunction
implements ContextDataLookupFunction<ProfileRequestContext, JWKSet> {
    @Nullable
    public JWKSet apply(@Nullable ProfileRequestContext input) {
        return Optional.ofNullable(input).map(profileRequesContext -> profileRequesContext.getInboundMessageContext()).map(messageContext -> messageContext.getMessage()).filter(ExplicitClientRegistrationRequest.class::isInstance).map(ExplicitClientRegistrationRequest.class::cast).map(request -> this.getJWKSet((ExplicitClientRegistrationRequest)request)).orElse(null);
    }

    @Nullable
    protected JWKSet getJWKSet(@Nullable ExplicitClientRegistrationRequest request) {
        if (request == null) {
            return null;
        }
        EntityStatement entityConfiguration = request.getEntityConfiguration();
        if (entityConfiguration != null) {
            return entityConfiguration.getClaimsSet().getJWKSet();
        }
        List<EntityStatement> trustChain = request.getTrustChain();
        return trustChain != null && !trustChain.isEmpty() ? trustChain.get(0).getClaimsSet().getJWKSet() : null;
    }
}

