/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class DefaultTrustChainMetadataPolicyMergingStrategy
extends AbstractIdentifiableInitializableComponent
implements BiFunction<List<EntityStatement>, String, Map<String, MetadataPolicy>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustChainMetadataPolicyMergingStrategy.class);
    @NonnullAfterInit
    private BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> metadataPolicyMergingStrategy;
    @NonnullAfterInit
    private Function<List<EntityStatement>, Map<String, MetadataPolicy>> localMetadataPolicyStrategy;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setMetadataPolicyMergingStrategy(@Nonnull BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> strategy) {
        this.checkSetterPreconditions();
        this.metadataPolicyMergingStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Metadata policy merging strategy cannot be null");
    }

    public void setLocalMetadataPolicyStrategy(@Nonnull Function<List<EntityStatement>, Map<String, MetadataPolicy>> strategy) {
        this.checkSetterPreconditions();
        this.localMetadataPolicyStrategy = (Function)Constraint.isNotNull(strategy, (String)"Local metadata policy strategy cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataPolicyMergingStrategy == null) {
            throw new ComponentInitializationException("Metadata policy merging strategy cannot be null");
        }
        if (this.localMetadataPolicyStrategy == null) {
            throw new ComponentInitializationException("Local metadata policy strategy cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nonnull
    public Map<String, MetadataPolicy> apply(@Nullable List<EntityStatement> trustChain, @Nullable String entityType) throws ConstraintViolationException {
        this.checkComponentActive();
        if (trustChain == null || trustChain.isEmpty()) {
            return CollectionSupport.emptyMap();
        }
        HashMap<String, MetadataPolicy> result = new HashMap<String, MetadataPolicy>();
        for (int i = trustChain.size(); i > 0; --i) {
            EntityStatement entityStatement = trustChain.get(i - 1);
            JSONObject policy = entityStatement.getClaimsSet().getMetadataPolicyJSONObject();
            if (policy == null || policy.isEmpty() || StringSupport.trimOrNull((String)entityType) == null) continue;
            try {
                assert (entityType != null);
                result.putAll(this.mergePolicies(result, this.parseMetadataPolicy(entityStatement, entityType)));
                continue;
            }
            catch (ConstraintViolationException e) {
                throw new ConstraintViolationException("Could not merge federation metadata policies");
            }
        }
        try {
            result.putAll(this.mergePolicies(result, this.localMetadataPolicyStrategy.apply(trustChain)));
        }
        catch (ConstraintViolationException e) {
            throw new ConstraintViolationException("Could not merge local metadata policy in the federation policy");
        }
        return result;
    }

    @Nonnull
    protected Map<String, MetadataPolicy> mergePolicies(@Nullable Map<String, MetadataPolicy> first, @Nullable Map<String, MetadataPolicy> second) throws ConstraintViolationException {
        Pair<Map<String, MetadataPolicy>, Boolean> result = this.metadataPolicyMergingStrategy.apply(first, second);
        if (result != null && Boolean.TRUE.equals(result.getSecond())) {
            Map mergedMap = (Map)result.getFirst();
            return mergedMap == null ? CollectionSupport.emptyMap() : mergedMap;
        }
        throw new ConstraintViolationException("Merge failed");
    }

    @Nullable
    protected Map<String, MetadataPolicy> parseMetadataPolicy(@Nonnull EntityStatement entityStatement, @Nonnull String entityType) throws ConstraintViolationException {
        Object metadataPolicyClaim = entityStatement.getClaimsSet().getClaim("metadata_policy");
        if (metadataPolicyClaim != null) {
            JavaType stringType = this.objectMapper.constructType(String.class);
            JavaType metadataPolicyType = this.objectMapper.constructType(MetadataPolicy.class);
            MapType metadataPolicyMapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, stringType, metadataPolicyType);
            MapType metadataPolicyByEntityTypeMapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, stringType, (JavaType)metadataPolicyMapType);
            try {
                Map result = (Map)this.objectMapper.readValue(metadataPolicyClaim.toString(), (JavaType)metadataPolicyByEntityTypeMapType);
                if (result != null) {
                    return (Map)result.get(entityType);
                }
            }
            catch (JsonProcessingException e) {
                this.log.warn("Could not parse trust mark issuers from the trust chain", (Throwable)e);
            }
        }
        return null;
    }
}

