/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyCachedMessageContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ValidateSelectedTrustChain
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateSelectedTrustChain.class);
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyCachedMessageContext> resolveEntityContextLookupStrategy;
    @NonnullBeforeExec
    private ResolveEntityRequest validatedRequest;

    public ValidateSelectedTrustChain() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        Function recls = new ChildContextLookup(RelyingPartyCachedMessageContext.class).compose((Function)new InboundMessageContextLookup());
        assert (recls != null);
        this.resolveEntityContextLookupStrategy = recls;
    }

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity configuration metadata cache cannot be null");
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setResolveEntityContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyCachedMessageContext> strategy) {
        this.checkSetterPreconditions();
        this.resolveEntityContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity configuration metadata cache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ResolveEntityRequest resolveEntityRequest;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyCachedMessageContext cachedResponseContext = this.resolveEntityContextLookupStrategy.apply(profileRequestContext);
        if (cachedResponseContext == null) {
            this.log.error("{} Could not resolve cached message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Request request = cachedResponseContext.getValidatedRequest();
        if (!(request instanceof ResolveEntityRequest)) {
            this.log.error("{} Could not resolve request message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.validatedRequest = resolveEntityRequest = (ResolveEntityRequest)request;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Pair<List<EntityStatement>, Map<String, Map<String, Object>>> selectedTrustChain;
        RelyingPartyTrustChainContext trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        Pair<List<EntityStatement>, Map<String, Map<String, Object>>> pair = selectedTrustChain = trustChainContext != null ? trustChainContext.getSelectedTrustChain() : null;
        if (selectedTrustChain == null || selectedTrustChain.getFirst() == null) {
            List<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> allChains;
            List<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> list = allChains = trustChainContext != null ? trustChainContext.getPolicyCompliantTrustChains() : null;
            if (allChains == null || allChains.isEmpty()) {
                if (this.isSubjectValid(this.validatedRequest.getSubject())) {
                    this.log.debug("{} No trust chains were resolved, subject is valid", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidTrustAnchor");
                    return;
                }
                this.log.debug("{} No trust chains were resolved, subject is not valid", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                return;
            }
            this.log.debug("{} No trust chains left to choose from", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidTrustAnchor");
            return;
        }
        List<String> trustAnchors = this.validatedRequest.getTrustAnchors();
        List candidateChain = (List)selectedTrustChain.getFirst();
        assert (candidateChain != null);
        String candidateAnchor = ((EntityStatement)candidateChain.get(candidateChain.size() - 1)).getEntityID().getValue();
        if (!trustAnchors.contains(candidateAnchor)) {
            this.log.debug("{} Selected trust chain candidate has unrequested trust anchor {}", (Object)this.getLogPrefix(), (Object)candidateAnchor);
            assert (trustChainContext != null);
            List<List<EntityStatement>> rejectedTrustChains = trustChainContext.getRejectedTrustChains();
            if (rejectedTrustChains == null) {
                trustChainContext.setRejectedTrustChains(List.of((List)selectedTrustChain.getFirst()));
            } else {
                ArrayList<List<EntityStatement>> rejectedChains = new ArrayList<List<EntityStatement>>(rejectedTrustChains);
                rejectedChains.add((List)selectedTrustChain.getFirst());
                trustChainContext.setRejectedTrustChains(CollectionSupport.copyToList(rejectedChains));
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"ReselectTrustChain");
            return;
        }
    }

    protected boolean isSubjectValid(@Nonnull String subject) {
        SubjectEntityIDCriterion subjectCriterion = new SubjectEntityIDCriterion(subject);
        try {
            List result = this.entityConfigurationCache.get(new CriteriaSet(new Criterion[]{subjectCriterion}));
            if (result.size() == 1) {
                return true;
            }
        }
        catch (MetadataCacheException e) {
            this.log.debug("{} Exception catched when resolving entty configuration", (Throwable)e);
        }
        return false;
    }
}

