/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyCachedMessageContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ValidateResolveEntityRequest
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateResolveEntityRequest.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyCachedMessageContext> cachedMessageContextCreationStrategy;
    @NonnullAfterInit
    private MetadataCache<Map<String, LocalKeyContainer>> localTrustAnchorsCache;
    @NonnullBeforeExec
    private ResolveEntityRequest requestMessage;
    @NonnullBeforeExec
    private RelyingPartyCachedMessageContext cachedMessageContext;

    public ValidateResolveEntityRequest() {
        Function reccs = new ChildContextLookup(RelyingPartyCachedMessageContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (reccs != null);
        this.cachedMessageContextCreationStrategy = reccs;
    }

    public void setResolveEntityContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyCachedMessageContext> strategy) {
        this.checkSetterPreconditions();
        this.cachedMessageContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyResolveEntityContext creation strategy cannot be null");
    }

    public void setLocalTrustAnchorsCache(@Nonnull MetadataCache<Map<String, LocalKeyContainer>> cache) {
        this.checkSetterPreconditions();
        this.localTrustAnchorsCache = (MetadataCache)Constraint.isNotNull(cache, (String)"LocalTrustAnchorsCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.localTrustAnchorsCache == null) {
            throw new ComponentInitializationException("LocalTrustAnchorsCache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requestMessage = Optional.ofNullable(profileRequestContext.getInboundMessageContext()).map(messageContext -> messageContext.getMessage()).filter(ResolveEntityRequest.class::isInstance).map(ResolveEntityRequest.class::cast).orElse(null);
        if (this.requestMessage == null) {
            this.log.error("{} Unable to fetch the request message to operate on", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.cachedMessageContext = this.cachedMessageContextCreationStrategy.apply(profileRequestContext);
        if (this.cachedMessageContext == null) {
            this.log.error("{} Unable to create resolve entity context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List<String> validatedAnchors = this.requestMessage.getTrustAnchors().stream().filter(anchor -> this.isLocallyTrusted((String)anchor)).toList();
        if (validatedAnchors.isEmpty()) {
            this.log.info("{} No locally trusted anchors left after filtering", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidTrustAnchor");
            return;
        }
        this.log.debug("{} The following trust anchors were validated: {}", (Object)this.getLogPrefix(), validatedAnchors);
        this.cachedMessageContext.setValidatedRequest(new ResolveEntityRequest(this.requestMessage.getEndpointURI(), this.requestMessage.getSubject(), validatedAnchors, this.requestMessage.getEntityTypes()));
    }

    protected boolean isLocallyTrusted(@Nullable String candidate) {
        if (StringSupport.trimOrNull((String)candidate) == null) {
            return false;
        }
        assert (candidate != null);
        SubjectEntityIDCriterion criterion = new SubjectEntityIDCriterion(candidate);
        try {
            List result = this.localTrustAnchorsCache.get(new CriteriaSet(new Criterion[]{criterion}));
            if (result == null || result.isEmpty() || ((Map)result.get(0)).isEmpty()) {
                this.log.debug("{} No locally trusted keys found for {}", (Object)this.getLogPrefix(), (Object)candidate);
                return false;
            }
            return ((Map)result.get(0)).containsKey(candidate);
        }
        catch (MetadataCacheException e) {
            this.log.error("{} Could not fetch value for {} from the metadata cache", new Object[]{this.getLogPrefix(), candidate, e});
            return false;
        }
    }
}

