/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultSelectedTrustChainMetadataLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.LocalMetadataPolicyLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.MandatoryTrustMarksLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ValidateAutomaticRegistrationProfileConfiguration
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String RESELECT_TRUST_CHAIN = "ReselectTrustChain";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAutomaticRegistrationProfileConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientMetadata> selectedMetadataLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> mandatoryTrustMarksLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> localMetadataPolicyLookupStrategy;
    @NonnullAfterInit
    private BiFunction<OIDCClientInformation, Map<String, MetadataPolicy>, OIDCClientInformation> localMetadataPolicyMergingStrategy;
    @NonnullBeforeExec
    private RelyingPartyTrustChainContext trustChainContext;
    @NonnullBeforeExec
    private Pair<List<EntityStatement>, Map<String, Map<String, Object>>> selectedTrustChain;

    public ValidateAutomaticRegistrationProfileConfiguration() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        this.selectedMetadataLookupStrategy = new DefaultSelectedTrustChainMetadataLookupStrategy();
        this.mandatoryTrustMarksLookupStrategy = new MandatoryTrustMarksLookupFunction();
        this.localMetadataPolicyLookupStrategy = new LocalMetadataPolicyLookupFunction();
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setSelectedMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientMetadata> strategy) {
        this.checkSetterPreconditions();
        this.selectedMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SelectedMetadataLookupStrategy cannot be null");
    }

    public void setMandatoryTrustMarksLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.mandatoryTrustMarksLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Mandatory trust marks lookup strategy cannot be null");
    }

    public void setLocalMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        this.checkSetterPreconditions();
        this.localMetadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Local metadata policy lookup strategy cannot be null");
    }

    public void setLocalMetadataPolicyMergingStrategy(@Nonnull BiFunction<OIDCClientInformation, Map<String, MetadataPolicy>, OIDCClientInformation> strategy) {
        this.checkSetterPreconditions();
        this.localMetadataPolicyMergingStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Local metadata policy merging strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (this.trustChainContext == null || this.trustChainContext.getSelectedTrustChain() == null) {
            this.log.error("{} Unable to locate selected trust chain", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.selectedTrustChain = this.trustChainContext.getSelectedTrustChain();
        assert (this.selectedTrustChain != null);
        if (this.selectedTrustChain.getFirst() == null || this.selectedTrustChain.getSecond() == null) {
            this.log.error("{} Selected trust chain contents is not populated", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation;
        OIDCClientMetadata metadata = this.selectedMetadataLookupStrategy.apply(profileRequestContext);
        if (metadata == null) {
            this.log.error("{} Unable to parse the RP metadata for storing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        Map<String, MetadataPolicy> localMetadataPolicy = this.localMetadataPolicyLookupStrategy.apply(profileRequestContext);
        if (localMetadataPolicy != null && !localMetadataPolicy.isEmpty()) {
            this.log.debug("{} Applying local metadata policy into the client metadata", (Object)this.getLogPrefix());
            clientInformation = this.localMetadataPolicyMergingStrategy.apply(new OIDCClientInformation(new ClientID(((EntityStatement)((List)this.selectedTrustChain.getFirst()).get(0)).getEntityID().getValue()), metadata), localMetadataPolicy);
            if (clientInformation == null) {
                this.log.error("{} Could not apply the local metadata policy into the client metadata", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return;
            }
            this.selectedTrustChain.setSecond(Map.of("openid_relying_party", clientInformation.toJSONObject()));
        } else {
            clientInformation = new OIDCClientInformation(new ClientID(((EntityStatement)((List)this.selectedTrustChain.getFirst()).get(0)).getEntityID().getValue()), metadata);
        }
        String clientId = clientInformation.getID().getValue();
        List<String> mandatoryTrustMarks = this.mandatoryTrustMarksLookupStrategy.apply(profileRequestContext);
        if (mandatoryTrustMarks != null && !mandatoryTrustMarks.isEmpty()) {
            this.log.debug("{} Verifying the mandatory trust marks {}", (Object)this.getLogPrefix(), mandatoryTrustMarks);
            Map<String, List<String>> verifiedTrustMarks = this.trustChainContext.getVerifiedTrustMarkIds();
            if (verifiedTrustMarks == null || verifiedTrustMarks.get(clientId) == null || !verifiedTrustMarks.get(clientId).containsAll(mandatoryTrustMarks)) {
                this.log.info("{} Rejecting registration as some of the following mandatory trust marks are missing: {}", (Object)this.getLogPrefix(), mandatoryTrustMarks);
                List<List<EntityStatement>> rejectedTrustChains = this.trustChainContext.getRejectedTrustChains();
                if (rejectedTrustChains == null) {
                    this.trustChainContext.setRejectedTrustChains(List.of((List)this.selectedTrustChain.getFirst()));
                } else {
                    ArrayList<List<EntityStatement>> rejectedChains = new ArrayList<List<EntityStatement>>(rejectedTrustChains);
                    rejectedChains.add((List)this.selectedTrustChain.getFirst());
                    this.trustChainContext.setRejectedTrustChains(CollectionSupport.copyToList(rejectedChains));
                }
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)RESELECT_TRUST_CHAIN);
                return;
            }
        }
        List trustChain = (List)this.selectedTrustChain.getFirst();
        assert (trustChain != null);
        this.trustChainContext.setSelectedMetadataExpiration(this.resolveTrustChainExpiration(trustChain));
        OIDCMetadataContext oidcCtx = new OIDCMetadataContext();
        oidcCtx.setClientInformation(clientInformation);
        profileRequestContext.ensureInboundMessageContext().addSubcontext((BaseContext)oidcCtx);
        this.log.debug("{} Client information attached to the OIDCMetadataContext", (Object)this.getLogPrefix());
    }

    @Nullable
    private Instant resolveTrustChainExpiration(@Nonnull List<EntityStatement> trustChain) {
        Instant metadataExpiration = null;
        for (EntityStatement statement : trustChain) {
            Instant statementExpiration = statement.getClaimsSet().getExpirationTime().toInstant();
            metadataExpiration = metadataExpiration == null ? statementExpiration : (statementExpiration.isBefore(metadataExpiration) ? statementExpiration : metadataExpiration);
        }
        return metadataExpiration;
    }
}

