/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultSelectedTrustChainMetadataLookupStrategy;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.ClientInformationManager;
import net.shibboleth.oidc.metadata.ClientInformationManagerException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class StoreAutomaticRegistration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoreAutomaticRegistration.class);
    @NonnullAfterInit
    private ClientInformationManager clientInformationManager;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientMetadata> selectedMetadataLookupStrategy;
    @NonnullBeforeExec
    private OIDCClientInformation clientInformation;
    @NonnullBeforeExec
    private Instant expiration;

    public StoreAutomaticRegistration() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        this.selectedMetadataLookupStrategy = new DefaultSelectedTrustChainMetadataLookupStrategy();
    }

    @NonnullAfterInit
    public ClientInformationManager getClientInformationManager() {
        return this.clientInformationManager;
    }

    public void setClientInformationManager(@Nonnull ClientInformationManager manager) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientInformationManager = (ClientInformationManager)Constraint.isNotNull((Object)manager, (String)"The client information manager cannot be null!");
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setSelectedMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientMetadata> strategy) {
        this.checkSetterPreconditions();
        this.selectedMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SelectedMetadataLookupStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientInformationManager == null) {
            throw new ComponentInitializationException("ClientInformationManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyTrustChainContext trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (trustChainContext == null || trustChainContext.getSelectedTrustChain() == null) {
            this.log.error("{} Unable to locate selected trust chain", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        OIDCClientMetadata metadata = this.selectedMetadataLookupStrategy.apply(profileRequestContext);
        if (metadata == null) {
            this.log.error("{} Unable to parse the RP metadata for storing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        Pair<List<EntityStatement>, Map<String, Map<String, Object>>> selectedTrustChain = trustChainContext.getSelectedTrustChain();
        assert (selectedTrustChain != null);
        this.clientInformation = new OIDCClientInformation(new ClientID(((EntityStatement)((List)selectedTrustChain.getFirst()).get(0)).getEntityID().getValue()), metadata);
        this.expiration = trustChainContext.getSelectedMetadataExpiration();
        if (this.expiration == null) {
            this.log.error("{} Unable to resolve expiration time for the selected metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Storing automatically registered client information", (Object)this.getLogPrefix());
        try {
            this.log.debug("{} Registration will expire on {}", (Object)this.getLogPrefix(), (Object)this.expiration);
            assert (this.clientInformation != null);
            this.clientInformationManager.storeClientInformation(this.clientInformation, this.expiration, true);
        }
        catch (ClientInformationManagerException e) {
            this.log.error("{} Could not store the client information", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        this.log.info("{} Client information successfully stored for {}", (Object)this.getLogPrefix(), (Object)this.clientInformation.getID().getValue());
    }
}

