/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultTrustChainSelectionStrategy;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class SelectTrustChain
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SelectTrustChain.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextCreationStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> selectedTrustChainLookupStrategy;
    @NonnullBeforeExec
    private RelyingPartyTrustChainContext trustChainContext;

    public SelectTrustChain() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        Function rpccs = new ChildContextLookup(RelyingPartyContext.class, true).compose(tcls);
        assert (rpccs != null);
        this.relyingPartyContextCreationStrategy = rpccs;
        this.selectedTrustChainLookupStrategy = new DefaultTrustChainSelectionStrategy();
    }

    public void setRelyingPartyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext creation strategy cannot be null");
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setSelectedTrustChainLookupStrategy(@Nonnull Function<ProfileRequestContext, Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> strategy) {
        this.checkSetterPreconditions();
        this.selectedTrustChainLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SelectedTrustChainLookupStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selectedTrustChainLookupStrategy == null) {
            throw new ComponentInitializationException("Trust chain selection strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (this.trustChainContext == null || this.trustChainContext.getPolicyCompliantTrustChains() == null) {
            this.log.debug("{} Unable to locate policy-compliant trust chains, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoTrustChainsResolved");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Pair<List<EntityStatement>, Map<String, Map<String, Object>>> selectedChain = this.selectedTrustChainLookupStrategy.apply(profileRequestContext);
        if (selectedChain == null || selectedChain.getFirst() == null || selectedChain.getSecond() == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} No selected trust chain could be resolved", (Object)this.getLogPrefix());
            return;
        }
        List<List<EntityStatement>> rejectedTrustChains = this.trustChainContext.getRejectedTrustChains();
        if (rejectedTrustChains != null && rejectedTrustChains.contains(selectedChain.getFirst())) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} The selected trust chain has been previously rejected", (Object)this.getLogPrefix());
            return;
        }
        this.trustChainContext.setSelectedTrustChains(selectedChain);
        List selectedTrustChain = (List)selectedChain.getFirst();
        assert (selectedTrustChain != null);
        RelyingPartyContext relyingPartyContext = this.relyingPartyContextCreationStrategy.apply(profileRequestContext);
        relyingPartyContext.setRelyingPartyId(((EntityStatement)selectedTrustChain.get(selectedTrustChain.size() - 1)).getEntityID().getValue());
        relyingPartyContext.setVerified(Boolean.valueOf(true));
    }
}

