/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkOwnersCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;

public class ResolveTrustMarks
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ResolveTrustMarks.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @NonnullAfterInit
    private Function<List<EntityStatement>, Map<String, List<SignedJWT>>> trustChainTrustMarksParsingStrategy;
    @NonnullAfterInit
    private Function<List<EntityStatement>, Map<String, List<String>>> trustedTrustMarkIssuersLookupStrategy;
    @NonnullAfterInit
    private Function<List<EntityStatement>, Map<String, Map<String, Object>>> trustedTrustMarkOwnersLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> trustedTrustMarkIssuersOnlyCondition;
    @NonnullAfterInit
    private MetadataCache<List<List<EntityStatement>>> trustChainCache;
    @NonnullAfterInit
    private TrustEngine<SignedJWT> trustEngine;
    @NonnullAfterInit
    private TrustEngine<SignedJWT> delegationTrustEngine;
    @NonnullAfterInit
    private Function<ProfileRequestContext, ClaimsValidator> trustMarkClaimsValidationLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, ClaimsValidator> delegatedTrustMarkClaimsValidationLookupStrategy;
    @NonnullBeforeExec
    private RelyingPartyTrustChainContext trustChainContext;
    @NonnullBeforeExec
    private List<EntityStatement> selectedTrustChain;
    @NonnullBeforeExec
    private ClaimsValidator trustMarkClaimsValidator;
    @NonnullBeforeExec
    private ClaimsValidator delegatedTrustMarkClaimsValidator;

    public ResolveTrustMarks() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        this.trustedTrustMarkIssuersOnlyCondition = PredicateSupport.alwaysTrue();
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setTrustChainTrustMarksParsingStrategy(@Nonnull Function<List<EntityStatement>, Map<String, List<SignedJWT>>> strategy) {
        this.checkSetterPreconditions();
        this.trustChainTrustMarksParsingStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainTrustMarksParsingStrategy cannot be null");
    }

    public void setTrustedTrustMarkIssuersLookupStrategy(@Nonnull Function<List<EntityStatement>, Map<String, List<String>>> strategy) {
        this.checkSetterPreconditions();
        this.trustedTrustMarkIssuersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"trustedTrustMarkIssuersLookupStrategy cannot be null");
    }

    public void setTrustedTrustMarkOwnersLookupStrategy(@Nonnull Function<List<EntityStatement>, Map<String, Map<String, Object>>> strategy) {
        this.checkSetterPreconditions();
        this.trustedTrustMarkOwnersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"trustedTrustMarkOwnersLookupStrategy cannot be null");
    }

    public void setTrustedTrustMarkIssuersOnlyCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.trustedTrustMarkIssuersOnlyCondition = (Predicate)Constraint.isNotNull(condition, (String)"TrustedTrustMarkIssuersOnlyCondition cannot be null");
    }

    public void setTrustChainCache(@Nonnull MetadataCache<List<List<EntityStatement>>> cache) {
        this.checkSetterPreconditions();
        this.trustChainCache = (MetadataCache)Constraint.isNotNull(cache, (String)"TrustChainCache cannot be null");
    }

    public void setTrustEngine(@Nonnull TrustEngine<SignedJWT> engine) {
        this.checkSetterPreconditions();
        this.trustEngine = (TrustEngine)Constraint.isNotNull(engine, (String)"Trust Engine cannot be null");
    }

    public void setDelegationTrustEngine(@Nonnull TrustEngine<SignedJWT> engine) {
        this.checkSetterPreconditions();
        this.delegationTrustEngine = (TrustEngine)Constraint.isNotNull(engine, (String)"Delegation Trust Engine cannot be null");
    }

    public void setTrustMarkClaimsValidationLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.checkSetterPreconditions();
        this.trustMarkClaimsValidationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustMarkClaimsValidationLookupStrategy cannot be null");
    }

    public void setDelegatedTrustMarkClaimsValidationLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.checkSetterPreconditions();
        this.delegatedTrustMarkClaimsValidationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DelegatedTrustMarkClaimsValidationLookupStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.trustChainCache == null) {
            throw new ComponentInitializationException("TrustChainCache cannot be null");
        }
        if (this.trustEngine == null) {
            throw new ComponentInitializationException("Trust Engine cannot be null");
        }
        if (this.delegationTrustEngine == null) {
            throw new ComponentInitializationException("Delegation Trust Engine cannot be null");
        }
        if (this.trustChainTrustMarksParsingStrategy == null) {
            throw new ComponentInitializationException("Trust marks parsing strategy cannot be null");
        }
        if (this.trustedTrustMarkIssuersLookupStrategy == null) {
            throw new ComponentInitializationException("Trusted trust mark issuers lookup strategy cannot be null");
        }
        if (this.trustedTrustMarkOwnersLookupStrategy == null) {
            throw new ComponentInitializationException("Trusted trust mark owners lookup strategy cannot be null");
        }
        if (this.trustMarkClaimsValidationLookupStrategy == null) {
            throw new ComponentInitializationException("TrustMarkClaimsValidationLookupStrategy cannot be null");
        }
        if (this.delegatedTrustMarkClaimsValidationLookupStrategy == null) {
            throw new ComponentInitializationException("DelegatedTrustMarkClaimsValidationLookupStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (this.trustChainContext == null || this.trustChainContext.getPolicyCompliantTrustChains() == null) {
            this.log.error("{} Unable to locate policy-compliant trust chains", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        Pair<List<EntityStatement>, Map<String, Map<String, Object>>> selectedChain = this.trustChainContext.getSelectedTrustChain();
        if (selectedChain == null || selectedChain.getFirst() == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} No selected trust chain could be resolved", (Object)this.getLogPrefix());
            return false;
        }
        this.selectedTrustChain = (List)selectedChain.getFirst();
        assert (this.selectedTrustChain != null);
        if (this.selectedTrustChain.size() < 3) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} Unexpected length in the selected trust chain: {}", (Object)this.getLogPrefix(), (Object)this.selectedTrustChain.size());
            return false;
        }
        this.trustMarkClaimsValidator = this.trustMarkClaimsValidationLookupStrategy.apply(profileRequestContext);
        if (this.trustMarkClaimsValidator == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            this.log.error("{} Unable to locate trust mark claims validator", (Object)this.getLogPrefix());
            return false;
        }
        this.delegatedTrustMarkClaimsValidator = this.delegatedTrustMarkClaimsValidationLookupStrategy.apply(profileRequestContext);
        if (this.delegatedTrustMarkClaimsValidator == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            this.log.error("{} Unable to locate delegated trust mark claims validator", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EntityStatement statement;
        List trustMarks;
        boolean onlyTrustedIssuers = this.trustedTrustMarkIssuersOnlyCondition.test(profileRequestContext);
        Map<String, List> chainTrustMarks = Optional.ofNullable(this.trustChainTrustMarksParsingStrategy.apply(this.selectedTrustChain)).orElseGet((Supplier<Map<String, List<SignedJWT>>>)NonnullSupplier.of((Object)CollectionSupport.emptyMap())).entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().filter(trustMark -> this.validateClaims(this.trustMarkClaimsValidator, (SignedJWT)trustMark, profileRequestContext)).toList()));
        if (chainTrustMarks == null || chainTrustMarks.isEmpty()) {
            this.log.debug("{} No valid trust marks found from the selected trust chain", (Object)this.getLogPrefix());
            return;
        }
        Map<String, List<String>> trustedIssuers = Optional.ofNullable(this.trustedTrustMarkIssuersLookupStrategy.apply(this.selectedTrustChain)).orElseGet((Supplier<Map<String, List<String>>>)NonnullSupplier.of((Object)CollectionSupport.emptyMap()));
        this.log.debug("{} Trusted trust mark issuers {}", (Object)this.getLogPrefix(), trustedIssuers);
        assert (trustedIssuers != null);
        Map<String, Map<String, Object>> trustedOwners = Optional.ofNullable(this.trustedTrustMarkOwnersLookupStrategy.apply(this.selectedTrustChain)).orElseGet((Supplier<Map<String, Map<String, Object>>>)NonnullSupplier.of((Object)CollectionSupport.emptyMap()));
        this.log.debug("{} Trusted trust mark owners {}", (Object)this.getLogPrefix(), trustedOwners);
        assert (trustedOwners != null);
        HashMap<String, List<SignedJWT>> verifiedTrustMarks = new HashMap<String, List<SignedJWT>>();
        Iterator<EntityStatement> iterator = this.selectedTrustChain.iterator();
        while (iterator.hasNext() && (trustMarks = chainTrustMarks.get((statement = iterator.next()).getEntityID().getValue())) != null && !trustMarks.isEmpty()) {
            verifiedTrustMarks.put(statement.getEntityID().getValue(), trustMarks.stream().filter(entry -> onlyTrustedIssuers ? this.checkTrustedIssuer((SignedJWT)entry, trustedIssuers, trustedOwners) : true).filter(entry -> this.verifyTrustMark((SignedJWT)entry, trustedOwners, profileRequestContext)).filter(Objects::nonNull).toList());
        }
        this.trustChainContext.setVerifiedTrustMarks(verifiedTrustMarks);
        Map<String, List<String>> verifiedTrustMarkIds = verifiedTrustMarks.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().map(list -> this.getTrustMarkId((SignedJWT)list)).toList()));
        this.log.debug("{} The following trust marks are validated: {}", (Object)this.getLogPrefix(), verifiedTrustMarkIds);
        this.trustChainContext.setVerifiedTrustMarkIds(verifiedTrustMarkIds);
    }

    protected boolean validateClaims(@Nullable ClaimsValidator claimsValidator, @Nullable SignedJWT jwt, @Nonnull ProfileRequestContext profileRequestContext) {
        if (claimsValidator == null || jwt == null) {
            return false;
        }
        try {
            JWTClaimsSet claimsSet = jwt.getJWTClaimsSet();
            assert (claimsSet != null);
            claimsValidator.validate(claimsSet, profileRequestContext);
            return true;
        }
        catch (ParseException | JWTValidationException e) {
            this.log.debug("{} Claims validation failed", (Object)this.getLogPrefix(), (Object)e);
            return false;
        }
    }

    protected boolean checkTrustedIssuer(@Nullable SignedJWT jwt, @Nonnull Map<String, List<String>> trustedIssuers, @Nonnull Map<String, Map<String, Object>> trustedOwners) {
        block9: {
            if (jwt == null) {
                return false;
            }
            try {
                JWTClaimsSet claimsSet = jwt.getJWTClaimsSet();
                String id = StringSupport.trimOrNull((String)this.getTrustMarkId(jwt));
                if (id == null) {
                    return false;
                }
                if (trustedIssuers.containsKey(id)) {
                    String issuer = claimsSet.getIssuer();
                    assert (issuer != null);
                    List<String> validIssuers = trustedIssuers.get(id);
                    if (validIssuers == null || !validIssuers.contains(issuer)) {
                        this.log.debug("{} Issuer {} is not valid trust mark issuer", (Object)this.getLogPrefix(), (Object)issuer);
                        return false;
                    }
                    break block9;
                }
                if (trustedOwners.containsKey(id)) {
                    this.log.debug("{} Trust mark ID {} is included in trusted owners", (Object)this.getLogPrefix(), (Object)id);
                    if (claimsSet.getStringClaim("delegation") == null) {
                        this.log.debug("(} Trust mark ID {} does not contain a delegation claim", (Object)this.getLogPrefix(), (Object)id);
                        return false;
                    }
                    break block9;
                }
                this.log.debug("{} Trust mark ID {} is not included in the trusted issuers", (Object)this.getLogPrefix(), (Object)id);
                return false;
            }
            catch (ParseException e) {
                this.log.error("{} Could not parse TrustMark JWT contents", (Object)this.getLogPrefix(), (Object)e);
                return false;
            }
        }
        return true;
    }

    protected boolean verifyTrustMark(@Nullable SignedJWT jwt, @Nonnull Map<String, Map<String, Object>> trustedOwners, @Nonnull ProfileRequestContext profileRequestContext) {
        List cacheResult;
        JWTClaimsSet trustMarkClaims;
        if (jwt == null) {
            return false;
        }
        try {
            trustMarkClaims = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.error("{} Could not parse the TrustMark JWT contents", (Object)this.getLogPrefix(), (Object)e);
            return false;
        }
        String issuer = trustMarkClaims.getIssuer();
        assert (issuer != null);
        this.log.debug("{} Resolving trust chain for {}", (Object)this.getLogPrefix(), (Object)issuer);
        try {
            cacheResult = this.trustChainCache.get(new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(issuer)}));
        }
        catch (MetadataCacheException e) {
            this.log.warn("{} Exception while fetching trust chains for {}", new Object[]{this.getLogPrefix(), issuer, e});
            return false;
        }
        if (cacheResult.isEmpty() || ((List)cacheResult.get(0)).isEmpty()) {
            this.log.warn("{} No trust chains resolved for {}", (Object)this.getLogPrefix(), (Object)issuer);
            return false;
        }
        List trustMarkChain = (List)((List)cacheResult.get(0)).get(0);
        EntityStatement trustMarkIssuer = (EntityStatement)trustMarkChain.get(0);
        assert (trustMarkIssuer != null);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityStatementCriterion(trustMarkIssuer)});
        this.log.trace("{} Validating entity statement {}", (Object)this.getLogPrefix(), (Object)trustMarkIssuer.getSignedStatement().serialize());
        try {
            if (this.trustEngine.validate((Object)jwt, criteria)) {
                String id = this.getTrustMarkId(jwt);
                assert (id != null);
                this.log.debug("{} Successfully validated trust mark {} issued by {}", new Object[]{this.getLogPrefix(), id, issuer});
                if (trustedOwners.containsKey(id)) {
                    return this.validateDelegatedTrustMark(trustMarkClaims, id, trustedOwners, profileRequestContext);
                }
                return true;
            }
        }
        catch (SecurityException e) {
            this.log.debug("{} Security exception while validating trust mark signature for {}", new Object[]{this.getLogPrefix(), issuer, e});
        }
        return false;
    }

    protected boolean validateDelegatedTrustMark(@Nonnull JWTClaimsSet trustMarkClaims, @Nonnull String id, @Nonnull Map<String, Map<String, Object>> trustedOwners, @Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Validating delegated trust mark {}", (Object)this.getLogPrefix(), (Object)id);
        try {
            SignedJWT delegationJwt = SignedJWT.parse((String)trustMarkClaims.getStringClaim("delegation"));
            CriteriaSet delegationCriteria = new CriteriaSet(new Criterion[]{new TrustMarkOwnersCriterion(trustedOwners), new SubjectEntityIDCriterion(id)});
            if (this.validateClaims(this.delegatedTrustMarkClaimsValidator, delegationJwt, profileRequestContext)) {
                assert (delegationJwt != null);
                if (this.delegationTrustEngine.validate((Object)delegationJwt, delegationCriteria)) {
                    String issuer = delegationJwt.getJWTClaimsSet().getIssuer();
                    this.log.debug("{} Successfully validated delegated {} signature issued by {}", new Object[]{this.getLogPrefix(), id, issuer});
                    if (issuer != null && issuer.equals(trustMarkClaims.getSubject())) {
                        return true;
                    }
                    this.log.debug("{} The issuer of the delegation {} does not match with the subject {}", new Object[]{this.getLogPrefix(), issuer, trustMarkClaims.getSubject()});
                }
            }
        }
        catch (SecurityException e) {
            this.log.debug("{} Security exception while validating trust mark signature for {}", new Object[]{this.getLogPrefix(), trustMarkClaims.getIssuer(), e});
        }
        catch (ParseException e) {
            this.log.debug("{} Parsing exception while processing delegated trust mark from {}", new Object[]{this.getLogPrefix(), trustMarkClaims.getIssuer(), e});
        }
        return false;
    }

    @Nullable
    private String getTrustMarkId(@Nullable SignedJWT trustMark) {
        try {
            return trustMark == null ? null : trustMark.getJWTClaimsSet().getStringClaim("trust_mark_type");
        }
        catch (ParseException e) {
            this.log.error("{} Could not parse the TrustMark JWT contents", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
    }
}

