/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.Request;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyCachedMessageContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class LookupCachedResolveEntityResponse
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(LookupCachedResolveEntityResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyCachedMessageContext> cachedMessageContextLookupStrategy;
    @NonnullAfterInit
    private MetadataCache<ResolveEntityResponseContainer> responseCache;
    @NonnullBeforeExec
    private RelyingPartyCachedMessageContext cachedMessageContext;
    @NonnullBeforeExec
    private ResolveEntityRequest validatedRequest;

    public LookupCachedResolveEntityResponse() {
        Function recls = new ChildContextLookup(RelyingPartyCachedMessageContext.class).compose((Function)new InboundMessageContextLookup());
        assert (recls != null);
        this.cachedMessageContextLookupStrategy = recls;
    }

    public void setCachedMessageContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyCachedMessageContext> strategy) {
        this.checkSetterPreconditions();
        this.cachedMessageContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    public void setResponseCache(@Nonnull MetadataCache<ResolveEntityResponseContainer> cache) {
        this.checkSetterPreconditions();
        this.responseCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Response metadata cache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responseCache == null) {
            throw new ComponentInitializationException("Response metadata cache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ResolveEntityRequest resolveEntityRequest;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.cachedMessageContext = this.cachedMessageContextLookupStrategy.apply(profileRequestContext);
        if (this.cachedMessageContext == null) {
            this.log.error("{} Could not resolve cached response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Request request = this.cachedMessageContext.getValidatedRequest();
        if (!(request instanceof ResolveEntityRequest)) {
            this.log.error("{} Could not resolve validated resolve entity request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.validatedRequest = resolveEntityRequest = (ResolveEntityRequest)request;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.validatedRequest != null);
        ResolveEntityRequestCriterion requestCriterion = new ResolveEntityRequestCriterion(this.validatedRequest);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{requestCriterion});
        try {
            List result = this.responseCache.get(criteria);
            if (result.size() == 1) {
                ResolveEntityResponseContainer cachedResponse = (ResolveEntityResponseContainer)result.get(0);
                this.cachedMessageContext.setCachedResponse(cachedResponse.getResponse());
                this.log.debug("{} Response found from the cache, publishing event {}", (Object)this.getLogPrefix(), (Object)"CachedResolveEntityResponseFound");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CachedResolveEntityResponseFound");
                return;
            }
            this.log.debug("{} No cached response record found from the metadata cache", (Object)this.getLogPrefix(), (Object)result.size());
        }
        catch (MetadataCacheException e) {
            this.log.error("{} Could not fetch response record from the metadata cache", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

