/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyCachedMessageContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class LookupCachedEntityConfigurationResponse
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(LookupCachedEntityConfigurationResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyCachedMessageContext> cachedMessageContextCreationStrategy;
    @NonnullAfterInit
    private MetadataCache<NimbusResponseContainer> responseCache;
    @NonnullBeforeExec
    private RelyingPartyCachedMessageContext cachedMessageContext;

    public LookupCachedEntityConfigurationResponse() {
        ChildContextLookup recls = new ChildContextLookup(RelyingPartyCachedMessageContext.class, true);
        assert (recls != null);
        this.cachedMessageContextCreationStrategy = recls;
    }

    public void setCachedMessageContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyCachedMessageContext> strategy) {
        this.checkSetterPreconditions();
        this.cachedMessageContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    public void setResponseCache(@Nonnull MetadataCache<NimbusResponseContainer> cache) {
        this.checkSetterPreconditions();
        this.responseCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Response metadata cache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responseCache == null) {
            throw new ComponentInitializationException("Response metadata cache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.cachedMessageContext = this.cachedMessageContextCreationStrategy.apply(profileRequestContext);
        if (this.cachedMessageContext == null) {
            this.log.error("{} Could not create cached response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        CriteriaSet criteria = new CriteriaSet();
        try {
            List result = this.responseCache.get(criteria);
            if (result.size() == 1) {
                NimbusResponseContainer cachedResponse = (NimbusResponseContainer)result.get(0);
                this.cachedMessageContext.setCachedResponse(cachedResponse.getResponse());
                this.log.debug("{} Response found from the cache, publishing event {}", (Object)this.getLogPrefix(), (Object)"CachedEntityConfigurationResponseFound");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CachedEntityConfigurationResponseFound");
                return;
            }
            this.log.debug("{} No cached response record found from the metadata cache", (Object)this.getLogPrefix(), (Object)result.size());
        }
        catch (MetadataCacheException e) {
            this.log.error("{} Could not fetch response record from the metadata cache", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

