/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.EntityStatementContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;

public class JWTClaimsSetFromEntityStatementLookupFunction
implements Function<MessageContext, JWTClaimsSet> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(JWTClaimsSetFromEntityStatementLookupFunction.class);
    @Nonnull
    private Function<MessageContext, EntityStatementContext> entityStatementContextLookupStrategy;

    public JWTClaimsSetFromEntityStatementLookupFunction() {
        ChildContextLookup escl = new ChildContextLookup(EntityStatementContext.class);
        assert (escl != null);
        this.entityStatementContextLookupStrategy = escl;
    }

    public void setEntityStatementContextCreationStrategy(@Nonnull Function<MessageContext, EntityStatementContext> strategy) {
        this.entityStatementContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityStatementContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public JWTClaimsSet apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        EntityStatementContext entityStatementCtx = this.entityStatementContextLookupStrategy.apply(messageContext);
        if (entityStatementCtx == null) {
            return null;
        }
        JWT jwt = entityStatementCtx.getJWT();
        try {
            if (jwt != null) {
                return jwt.getJWTClaimsSet();
            }
        }
        catch (ParseException e) {
            this.log.error("Could not fetch the claims set from entity statement", (Throwable)e);
        }
        return null;
    }
}

