/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class GenerateClientID
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GenerateClientID.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, ClientID> clientIDLookupStrategy;
    @Nullable
    private OIDCClientRegistrationResponseContext oidcResponseCtx;
    @NonnullBeforeExec
    private String entityId;

    public GenerateClientID() {
        Function orcls = new ChildContextLookup(OIDCClientRegistrationResponseContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (orcls != null);
        this.oidcResponseContextLookupStrategy = orcls;
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientIDLookupStrategy == null) {
            throw new ComponentInitializationException("ClientIDLookupStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcResponseCtx = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (this.oidcResponseCtx == null) {
            this.log.debug("{} No OIDC client registration response context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        ClientID clientId = this.clientIDLookupStrategy.apply(profileRequestContext.getInboundMessageContext());
        if (clientId == null || clientId.getValue() == null) {
            this.log.error("{} No client ID could be resolved via inbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.entityId = clientId.getValue();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.oidcResponseCtx != null);
        this.oidcResponseCtx.setClientId(this.entityId);
    }
}

