/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jwt.JWT;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.EntityStatementContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;

public class EntityStatementUpdateStrategy
implements BiConsumer<JWT, MessageContext> {
    @Nonnull
    private Function<MessageContext, EntityStatementContext> entityStatementContextLookupStrategy;

    public EntityStatementUpdateStrategy() {
        ChildContextLookup escls = new ChildContextLookup(EntityStatementContext.class);
        assert (escls != null);
        this.entityStatementContextLookupStrategy = escls;
    }

    @Override
    public void accept(JWT jwt, MessageContext messageContext) {
        if (messageContext == null) {
            return;
        }
        EntityStatementContext entityStatementCtx = this.entityStatementContextLookupStrategy.apply(messageContext);
        if (entityStatementCtx == null) {
            return;
        }
        entityStatementCtx.setJWT(jwt);
    }
}

