/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.Response;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.config.CachedErrorResponseLifetimeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyCachedMessageContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.profile.messaging.JSONErrorResponse;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class BuildResolveEntityErrorResponseFromEvent
extends AbstractProfileAction {
    public static final String DEFAULT_ERROR_CODE = "invalid_request";
    public static final int DEFAULT_HTTP_STATUS_CODE = 400;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildResolveEntityErrorResponseFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    private Map<String, ErrorObject> mappedErrors = new HashMap<String, ErrorObject>();
    private int defaultStatusCode = 400;
    private String defaultCode = "invalid_request";
    @NonnullAfterInit
    private MetadataCache<ResolveEntityResponseContainer> responseCache;
    @Nonnull
    private Function<ProfileRequestContext, Duration> cachedResponseLifetimeLookupStrategy = new CachedErrorResponseLifetimeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyCachedMessageContext> resolveEntityContextLookupStrategy;

    public BuildResolveEntityErrorResponseFromEvent() {
        Function recls = new ChildContextLookup(RelyingPartyCachedMessageContext.class).compose((Function)new InboundMessageContextLookup());
        assert (recls != null);
        this.resolveEntityContextLookupStrategy = recls;
    }

    public void setDefaultStatusCode(int code) {
        this.defaultStatusCode = code;
    }

    public void setDefaultCode(@Nonnull String code) {
        this.defaultCode = (String)Constraint.isNotNull((Object)code, (String)"Default code cannot be null");
    }

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setMappedErrors(@Nonnull Map<String, ErrorObject> errors) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.mappedErrors = (Map)Constraint.isNotNull(errors, (String)"Mapped errors cannot be null");
    }

    public void setResponseCache(@Nonnull MetadataCache<ResolveEntityResponseContainer> cache) {
        this.checkSetterPreconditions();
        this.responseCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Response metadata cache cannot be null");
    }

    public void setCachedResponseLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.cachedResponseLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setResolveEntityContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyCachedMessageContext> strategy) {
        this.checkSetterPreconditions();
        this.resolveEntityContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responseCache == null) {
            throw new ComponentInitializationException("Response metadata cache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context initialized, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ErrorObject error;
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            this.log.error("{} No event to be included in the response, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        assert (eventCtx != null);
        Object event = eventCtx.getEvent();
        assert (event != null);
        String eventValue = event.toString();
        if (this.mappedErrors.containsKey(eventValue)) {
            this.log.debug("{} Found mapped event for {}", (Object)this.getLogPrefix(), (Object)eventValue);
            error = this.mappedErrors.get(eventValue);
        } else {
            this.log.debug("{} No mapped event found for {}, creating general {}", new Object[]{this.getLogPrefix(), eventValue, this.defaultCode});
            error = new ErrorObject(this.defaultCode, eventValue, this.defaultStatusCode);
        }
        assert (error != null);
        JSONErrorResponse errorResponse = this.buildErrorResponse(error, profileRequestContext);
        if (errorResponse != null) {
            profileRequestContext.ensureOutboundMessageContext().setMessage((Object)errorResponse);
            this.log.debug("{} ErrorResponse successfully set as the outbound message", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Error response not formed", (Object)this.getLogPrefix());
        }
    }

    protected JSONErrorResponse buildErrorResponse(ErrorObject error, ProfileRequestContext profileRequestContext) {
        Request request;
        JSONErrorResponse response = new JSONErrorResponse(error);
        RelyingPartyCachedMessageContext resolveEntityContext = this.resolveEntityContextLookupStrategy.apply(profileRequestContext);
        if (resolveEntityContext != null && (request = resolveEntityContext.getValidatedRequest()) instanceof ResolveEntityRequest) {
            ResolveEntityRequest resolveEntityRequest = (ResolveEntityRequest)request;
            NimbusResponseCriterion responseCriterion = new NimbusResponseCriterion((Response)response);
            Duration cachedResponseLifetime = this.cachedResponseLifetimeLookupStrategy.apply(profileRequestContext);
            Instant expiration = Instant.now().plus(cachedResponseLifetime);
            assert (expiration != null);
            ResponseContainerExpirationCriterion expirationCriterion = new ResponseContainerExpirationCriterion(expiration);
            ResolveEntityRequestCriterion requestCriterion = new ResolveEntityRequestCriterion(resolveEntityRequest);
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{requestCriterion, responseCriterion, expirationCriterion});
            try {
                List result = this.responseCache.get(criteria);
                if (result.size() != 1) {
                    this.log.error("{} Unexpected result (size={}) when storing response record into the metadata cache", (Object)this.getLogPrefix(), (Object)result.size());
                } else {
                    this.log.debug("{} Response stored into the cache", (Object)this.getLogPrefix());
                }
            }
            catch (MetadataCacheException e) {
                this.log.error("{} Could not store the response record into the metadata cache", (Object)this.getLogPrefix(), (Object)e);
            }
        }
        return response;
    }
}

