/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.AbstractBuildEntityStatementAction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultSelectedTrustChainImmediateSuperiorLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultSelectedTrustChainTrustAnchorLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.ExplicitClientRegistrationRequestJWKSetLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class BuildExplicitRegistrationResponse
extends AbstractBuildEntityStatementAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildExplicitRegistrationResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, JWKSet> jwkSetLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> trustAnchorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> immediateSuperiorLookupStrategy;
    @NonnullBeforeExec
    private OIDCClientRegistrationResponseContext oidcResponseContext;
    @NonnullBeforeExec
    private RelyingPartyTrustChainContext trustChainContext;

    public BuildExplicitRegistrationResponse() {
        Function ocrrls = new ChildContextLookup(OIDCClientRegistrationResponseContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (ocrrls != null);
        this.oidcResponseContextLookupStrategy = ocrrls;
        this.jwkSetLookupStrategy = new ExplicitClientRegistrationRequestJWKSetLookupFunction();
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        this.trustAnchorLookupStrategy = new DefaultSelectedTrustChainTrustAnchorLookupStrategy();
        this.immediateSuperiorLookupStrategy = new DefaultSelectedTrustChainImmediateSuperiorLookupStrategy();
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    public void setJwkSetLookupStrategy(@Nonnull Function<ProfileRequestContext, JWKSet> strategy) {
        this.checkSetterPreconditions();
        this.jwkSetLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JWK set loookup strategy cannot be null");
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setTrustAnchorLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.trustAnchorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustAnchorLookupStrategy cannot be null");
    }

    public void setImmediateSuperiorLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.immediateSuperiorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ImmediateSuperiorLookupStrategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcResponseContext = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (this.oidcResponseContext == null) {
            this.log.debug("{} No OIDCClientRegistrationResponseContext associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (this.trustChainContext == null) {
            this.log.error("{} Unable to locate trust chain context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected boolean populateClaimsSetBuilder(@Nonnull JWTClaimsSet.Builder builder, @Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation = this.oidcResponseContext.getClientInformation();
        if (clientInformation == null) {
            this.log.debug("{} No client information set in the OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        builder.claim("metadata", (Object)CollectionSupport.singletonMap((Object)"openid_relying_party", (Object)clientInformation.toJSONObject()));
        JWKSet jwkSet = this.jwkSetLookupStrategy.apply(profileRequestContext);
        if (jwkSet == null) {
            this.log.error("{} Coud not resolve JWK set to be included in the response statement", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        builder.claim("jwks", (Object)jwkSet.toJSONObject(true));
        Instant expirationTime = this.trustChainContext.getSelectedMetadataExpiration();
        if (expirationTime == null) {
            this.log.error("{} Coud not resolve expiration time from the selected trust chain context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        builder.expirationTime(Date.from(expirationTime));
        String trustAnchor = this.trustAnchorLookupStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)trustAnchor) == null) {
            this.log.error("{} Unable to locate trust anchor from the context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        builder.claim("trust_anchor", (Object)trustAnchor);
        String superior = this.immediateSuperiorLookupStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)superior) == null) {
            this.log.error("{} Unable to locate immediate superior from the context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        builder.claim("authority_hints", List.of(superior));
        return true;
    }
}

